/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.aggregation.stage.AddFieldsStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.BucketStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.FacetStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.GroupStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.IndexStatsStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LimitStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LookupStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.LookupWithPipelineStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.MatchStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.OrderByStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ProjectStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.ReplaceRootStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.SkipStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.UnsetStage;
import de.bwaldvogel.mongo.backend.aggregation.stage.UnwindStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.TypeMismatchException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Aggregation {
    private final MongoCollection<?> collection;
    private final List<AggregationStage> stages = new ArrayList<AggregationStage>();
    private Map<String, Object> variables = Collections.emptyMap();

    private Aggregation(MongoCollection<?> collection) {
        this.collection = collection;
    }

    public static Aggregation fromPipeline(Object pipelineObject, MongoDatabase database, MongoCollection<?> collection) {
        if (!(pipelineObject instanceof List)) {
            throw new TypeMismatchException("'pipeline' option must be specified as an array");
        }
        ArrayList<Document> pipeline = new ArrayList<Document>();
        for (Object pipelineElement : (List)pipelineObject) {
            if (!(pipelineElement instanceof Document)) {
                throw new TypeMismatchException("Each element of the 'pipeline' array must be an object");
            }
            pipeline.add((Document)pipelineElement);
        }
        return Aggregation.fromPipeline(pipeline, database, collection);
    }

    private static Aggregation fromPipeline(List<Document> pipeline, MongoDatabase database, MongoCollection<?> collection) {
        Aggregation aggregation = new Aggregation(collection);
        block36: for (Document stage : pipeline) {
            String stageOperation;
            switch (stageOperation = CollectionUtils.getSingleElement(stage.keySet(), () -> {
                throw new MongoServerError(40323, "A pipeline stage specification object must contain exactly one field.");
            })) {
                case "$match": {
                    Document matchQuery = (Document)stage.get(stageOperation);
                    aggregation.addStage(new MatchStage(matchQuery));
                    continue block36;
                }
                case "$skip": {
                    Number numSkip = (Number)stage.get(stageOperation);
                    aggregation.addStage(new SkipStage(numSkip.longValue()));
                    continue block36;
                }
                case "$limit": {
                    Number numLimit = (Number)stage.get(stageOperation);
                    aggregation.addStage(new LimitStage(numLimit.longValue()));
                    continue block36;
                }
                case "$sort": {
                    Document orderBy = (Document)stage.get(stageOperation);
                    aggregation.addStage(new OrderByStage(orderBy));
                    continue block36;
                }
                case "$project": {
                    Document projection = (Document)stage.get(stageOperation);
                    aggregation.addStage(new ProjectStage(projection));
                    continue block36;
                }
                case "$count": {
                    String count = (String)stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(new Document("_id", null).append(count, new Document("$sum", 1))));
                    aggregation.addStage(new ProjectStage(new Document("_id", 0)));
                    continue block36;
                }
                case "$group": {
                    Document groupDetails = (Document)stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(groupDetails));
                    continue block36;
                }
                case "$addFields": {
                    Document addFieldsDetails = (Document)stage.get(stageOperation);
                    aggregation.addStage(new AddFieldsStage(addFieldsDetails));
                    continue block36;
                }
                case "$unwind": {
                    Object unwind = stage.get(stageOperation);
                    aggregation.addStage(new UnwindStage(unwind));
                    continue block36;
                }
                case "$lookup": {
                    Document lookup = (Document)stage.get(stageOperation);
                    if (lookup.containsKey("pipeline")) {
                        aggregation.addStage(new LookupWithPipelineStage(lookup, database));
                        continue block36;
                    }
                    aggregation.addStage(new LookupStage(lookup, database));
                    continue block36;
                }
                case "$replaceRoot": {
                    Document replaceRoot = (Document)stage.get(stageOperation);
                    aggregation.addStage(new ReplaceRootStage(replaceRoot));
                    continue block36;
                }
                case "$sortByCount": {
                    Object expression = stage.get(stageOperation);
                    aggregation.addStage(new GroupStage(new Document("_id", expression).append("count", new Document("$sum", 1))));
                    aggregation.addStage(new OrderByStage(new Document("count", -1).append("_id", 1)));
                    continue block36;
                }
                case "$bucket": {
                    Document bucket = (Document)stage.get(stageOperation);
                    aggregation.addStage(new BucketStage(bucket));
                    continue block36;
                }
                case "$facet": {
                    Document facet = (Document)stage.get(stageOperation);
                    aggregation.addStage(new FacetStage(facet, database, collection));
                    continue block36;
                }
                case "$unset": {
                    Object unset = stage.get(stageOperation);
                    aggregation.addStage(new UnsetStage(unset));
                    continue block36;
                }
                case "$indexStats": {
                    aggregation.addStage(new IndexStatsStage(collection));
                    continue block36;
                }
            }
            throw new MongoServerError(40324, "Unrecognized pipeline stage name: '" + stageOperation + "'");
        }
        return aggregation;
    }

    private List<Document> runStages() {
        return this.runStages(this.collection.queryAllAsStream());
    }

    public List<Document> runStages(Stream<Document> stream) {
        if (this.hasVariables()) {
            stream = stream.map(this::addAllVariables);
        }
        for (AggregationStage stage : this.stages) {
            stream = stage.apply(stream);
        }
        if (this.hasVariables()) {
            stream = stream.map(this::removeAllVariables);
        }
        return stream.collect(Collectors.toList());
    }

    private boolean hasVariables() {
        return !this.variables.isEmpty();
    }

    private Document addAllVariables(Document document) {
        Document clone = document.clone();
        clone.putAll((Map<? extends String, ?>)this.variables);
        return clone;
    }

    private Document removeAllVariables(Document document) {
        return CollectionUtils.removeAll(document, this.variables.keySet());
    }

    private void addStage(AggregationStage stage) {
        this.stages.add(stage);
    }

    public List<Document> computeResult() {
        if (this.collection == null) {
            return Collections.emptyList();
        }
        return this.runStages();
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = Collections.unmodifiableMap(variables);
    }
}

