/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.ArrayFilters;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.bson.Document;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface MongoCollection<P> {
    public MongoDatabase getDatabase();

    default public String getDatabaseName() {
        return this.getDatabase().getDatabaseName();
    }

    default public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    public String getCollectionName();

    public void addIndex(Index<P> var1);

    public void dropIndex(String var1);

    public void addDocument(Document var1);

    public void removeDocument(Document var1);

    default public Iterable<Document> queryAll() {
        return this.handleQuery(new Document());
    }

    default public Stream<Document> queryAllAsStream() {
        Spliterator<Document> documents = this.queryAll().spliterator();
        return StreamSupport.stream(documents, false);
    }

    default public Iterable<Document> handleQuery(Document query) {
        return this.handleQuery(query, 0, 0);
    }

    default public Stream<Document> handleQueryAsStream(Document query) {
        Spliterator<Document> documents = this.handleQuery(query).spliterator();
        return StreamSupport.stream(documents, false);
    }

    default public Iterable<Document> handleQuery(Document query, int numberToSkip, int numberToReturn) {
        return this.handleQuery(query, numberToSkip, numberToReturn, null);
    }

    public Iterable<Document> handleQuery(Document var1, int var2, int var3, Document var4);

    default public void insertDocuments(List<Document> documents) {
        for (Document document : documents) {
            this.addDocument(document);
        }
    }

    public Document updateDocuments(Document var1, Document var2, ArrayFilters var3, boolean var4, boolean var5);

    public int deleteDocuments(Document var1, int var2);

    public Document handleDistinct(Document var1);

    public Document getStats();

    public Document validate();

    public Document findAndModify(Document var1);

    public int count(Document var1, int var2, int var3);

    default public boolean isEmpty() {
        return this.count() == 0;
    }

    public int count();

    default public int getNumIndexes() {
        return this.getIndexes().size();
    }

    public List<Index<P>> getIndexes();

    public void renameTo(MongoDatabase var1, String var2);

    public void drop();
}

