/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Collectors;

public final class Json {
    private Json() {
    }

    public static String toJsonValue(Object value) {
        return Json.toJsonValue(value, false, "{", "}");
    }

    public static String toJsonValue(Object value, boolean compactKey, String jsonPrefix, String jsonSuffix) {
        if (Missing.isNullOrMissing(value)) {
            return "null";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "\"" + Json.escapeJson((String)value) + "\"";
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.toString(compactKey, jsonPrefix, jsonSuffix);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return Json.toJsonValue(date.toInstant().toString());
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return "[]";
            }
            return collection.stream().map(v -> Json.toJsonValue(v, compactKey, "{ ", " }")).collect(Collectors.joining(", ", "[ ", " ]"));
        }
        if (value instanceof ObjectId) {
            ObjectId objectId = (ObjectId)value;
            return objectId.getHexData();
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return "BinData(3, " + Json.toHex(uuid) + ")";
        }
        return Json.toJsonValue(value.toString());
    }

    static String escapeJson(String input) {
        String escaped = input;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    private static StringBuilder toHex(UUID uuid) {
        StringBuilder hex = new StringBuilder();
        byte[] bytes = Json.toBytes(uuid);
        for (int i = bytes.length; i > 0; --i) {
            hex.append(String.format("%02X", bytes[i - 1]));
        }
        return hex;
    }

    private static byte[] toBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        byteBuffer.putLong(uuid.getMostSignificantBits());
        return byteBuffer.array();
    }
}

