/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.ArrayFilters;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.UpdateOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.ConflictingUpdateOperatorsException;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import de.bwaldvogel.mongo.exception.ImmutableFieldException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.PathNotViableException;
import de.bwaldvogel.mongo.exception.TypeMismatchException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

class FieldUpdates {
    private final QueryMatcher matcher = new DefaultQueryMatcher();
    private final Map<String, String> renames = new LinkedHashMap<String, String>();
    private final Document document;
    private final String idField;
    private final UpdateOperator updateOperator;
    private final boolean upsert;
    private final Integer matchPos;
    private final ArrayFilters arrayFilters;

    FieldUpdates(Document document, UpdateOperator updateOperator, String idField, boolean upsert, Integer matchPos, ArrayFilters arrayFilters) {
        this.document = document;
        this.idField = idField;
        this.updateOperator = updateOperator;
        this.upsert = upsert;
        this.matchPos = matchPos;
        this.arrayFilters = arrayFilters;
    }

    void apply(Document change, String modifier) {
        for (String key : change.keySet()) {
            Object value = change.get(key);
            if (this.arrayFilters.canHandle(key)) {
                List<String> arrayKeys = this.arrayFilters.calculateKeys(this.document, key);
                for (String arrayKey : arrayKeys) {
                    this.apply(change, modifier, arrayKey, value);
                }
                continue;
            }
            this.apply(change, modifier, key, value);
        }
        this.applyRenames();
    }

    private void apply(Document change, String modifier, String key, Object value) {
        switch (this.updateOperator) {
            case SET_ON_INSERT: {
                if (!this.isUpsert()) {
                    return;
                }
            }
            case SET: {
                this.handleSet(key, value);
                break;
            }
            case UNSET: {
                this.handleUnset(key);
                break;
            }
            case PUSH: 
            case PUSH_ALL: 
            case ADD_TO_SET: {
                this.handlePushAllAddToSet(key, value);
                break;
            }
            case PULL: 
            case PULL_ALL: {
                this.handlePull(modifier, key, value);
                break;
            }
            case POP: {
                this.handlePop(modifier, key, value);
                break;
            }
            case INC: 
            case MUL: {
                this.handleIncMul(change, key, value);
                break;
            }
            case MIN: 
            case MAX: {
                this.handleMinMax(key, value);
                break;
            }
            case CURRENT_DATE: {
                this.handleCurrentDate(key, value);
                break;
            }
            case RENAME: {
                this.handleRename(key, value);
                break;
            }
            default: {
                throw new MongoServerError(10147, "Unsupported modifier: " + modifier);
            }
        }
    }

    private void handlePushAllAddToSet(String key, Object changeValue) {
        List<Object> list;
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            list = new ArrayList();
        } else if (value instanceof List) {
            list = FieldUpdates.asList(value);
        } else {
            if (this.updateOperator == UpdateOperator.ADD_TO_SET) {
                throw new MongoServerError(10141, "Cannot apply $addToSet to non-array field. Field named '" + key + "' has non-array type " + Utils.describeType(value));
            }
            if (this.updateOperator == UpdateOperator.PUSH_ALL || this.updateOperator == UpdateOperator.PUSH) {
                throw new BadValueException("The field '" + key + "' must be an array but is of type " + Utils.describeType(value) + " in document {" + "_id" + ": " + this.document.get("_id") + "}");
            }
            throw new IllegalArgumentException("Unsupported operator: " + (Object)((Object)this.updateOperator));
        }
        if (this.updateOperator == UpdateOperator.PUSH_ALL) {
            if (!(changeValue instanceof Collection)) {
                throw new MongoServerError(10153, "Modifier " + (Object)((Object)this.updateOperator) + " allowed for arrays only");
            }
            Collection valueList = (Collection)changeValue;
            list.addAll(valueList);
        } else {
            ArrayList<Object> pushValues = new ArrayList<Object>();
            if (changeValue instanceof Document && ((Document)changeValue).keySet().equals(Collections.singleton("$each"))) {
                Collection values = (Collection)((Document)changeValue).get("$each");
                pushValues.addAll(values);
            } else {
                pushValues.add(changeValue);
            }
            for (Object e : pushValues) {
                if (this.updateOperator == UpdateOperator.PUSH) {
                    list.add(e);
                    continue;
                }
                if (this.updateOperator == UpdateOperator.ADD_TO_SET) {
                    if (list.contains(e)) continue;
                    list.add(e);
                    continue;
                }
                throw new MongoServerException("internal server error. illegal modifier here: " + (Object)((Object)this.updateOperator));
            }
        }
        this.changeSubdocumentValue(this.document, key, list);
    }

    private void assertNotKeyField(String key) {
        if (key.equals(this.idField)) {
            throw new ImmutableFieldException("Performing an update on the path '" + this.idField + "' would modify the immutable field '" + this.idField + "'");
        }
    }

    private void handleUnset(String key) {
        this.assertNotKeyField(key);
        Utils.removeSubdocumentValue((Object)this.document, key, this.matchPos);
    }

    private void handleSet(String key, Object newValue) {
        Object oldValue = this.getSubdocumentValue(this.document, key);
        if (Utils.nullAwareEquals(newValue, oldValue)) {
            return;
        }
        if (!this.isUpsert()) {
            this.assertNotKeyField(key);
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void handlePull(String modifier, String key, Object pullValue) {
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (!(value instanceof List)) {
            if (this.updateOperator == UpdateOperator.PULL) {
                throw new BadValueException("Cannot apply " + modifier + " to a non-array value");
            }
            throw new BadValueException(modifier + " requires an array argument but was given a " + Utils.describeType(value));
        }
        List<Object> list = FieldUpdates.asList(value);
        if (modifier.equals("$pullAll")) {
            if (!(pullValue instanceof Collection)) {
                throw new BadValueException(modifier + " requires an array argument but was given a " + Utils.describeType(pullValue));
            }
            Collection valueList = (Collection)pullValue;
            list.removeIf(obj -> valueList.stream().anyMatch(v -> this.matcher.matchesValue(obj, v)));
        } else {
            list.removeIf(obj -> this.matcher.matchesValue(pullValue, obj));
        }
    }

    private void handlePop(String modifier, String key, Object popValue) {
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (!(value instanceof List)) {
            throw new MongoServerError(10143, modifier + " requires an array argument but was given a " + Utils.describeType(value));
        }
        List<Object> list = FieldUpdates.asList(value);
        if (!(popValue instanceof Number)) {
            throw new FailedToParseException("Expected a number in: " + key + ": " + Json.toJsonValue(popValue));
        }
        Object normalizedValue = Utils.normalizeValue(popValue);
        Assert.notNull(normalizedValue);
        if (!Utils.nullAwareEquals(normalizedValue, 1) && !Utils.nullAwareEquals(normalizedValue, -1)) {
            throw new FailedToParseException("$pop expects 1 or -1, found: " + Json.toJsonValue(popValue));
        }
        if (!list.isEmpty()) {
            if (Utils.nullAwareEquals(normalizedValue, -1)) {
                list.remove(0);
            } else {
                list.remove(list.size() - 1);
            }
        }
    }

    private void handleIncMul(Document change, String key, Object changeObject) {
        Number newValue;
        Number number;
        this.assertNotKeyField(key);
        Object value = this.getSubdocumentValue(this.document, key);
        if (Missing.isNullOrMissing(value)) {
            number = 0;
        } else if (value instanceof Number) {
            number = (Number)value;
        } else {
            String lastKey = Utils.getLastFragment(key);
            throw new TypeMismatchException("Cannot apply " + this.updateOperator.getValue() + " to a value of non-numeric type. {" + "_id" + ": " + Json.toJsonValue(this.document.get("_id")) + "} has the field '" + lastKey + "' of non-numeric type " + Utils.describeType(value));
        }
        if (!(changeObject instanceof Number)) {
            String operation = this.updateOperator == UpdateOperator.INC ? "increment" : "multiply";
            throw new TypeMismatchException("Cannot " + operation + " with non-numeric argument: " + change.toString(true));
        }
        Number changeValue = (Number)changeObject;
        if (this.updateOperator == UpdateOperator.INC) {
            newValue = Utils.addNumbers(number, changeValue);
        } else if (this.updateOperator == UpdateOperator.MUL) {
            newValue = Utils.multiplyNumbers(number, changeValue);
        } else {
            throw new RuntimeException();
        }
        this.changeSubdocumentValue(this.document, key, newValue);
    }

    private void handleMinMax(String key, Object newValue) {
        this.assertNotKeyField(key);
        Object oldValue = this.getSubdocumentValue(this.document, key);
        if (this.shouldChangeValue(oldValue, newValue)) {
            this.changeSubdocumentValue(this.document, key, newValue);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCurrentDate(String key, Object typeSpecification) {
        void var4_7;
        boolean useDate;
        this.assertNotKeyField(key);
        if (typeSpecification instanceof Boolean && Utils.isTrue(typeSpecification)) {
            useDate = true;
        } else {
            if (!(typeSpecification instanceof Document)) throw new BadValueException(Utils.describeType(typeSpecification) + " is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
            Object object = ((Document)typeSpecification).get("$type");
            if (object.equals("timestamp")) {
                useDate = false;
            } else {
                if (!object.equals("date")) throw new BadValueException("The '$type' string field is required to be 'date' or 'timestamp': {$currentDate: {field : {$type: 'date'}}}");
                useDate = true;
            }
        }
        if (useDate) {
            Date date = new Date();
        } else {
            BsonTimestamp bsonTimestamp = new BsonTimestamp(System.currentTimeMillis());
        }
        this.changeSubdocumentValue(this.document, key, var4_7);
    }

    private void handleRename(String key, Object toField) {
        this.assertNotKeyField(key);
        if (!(toField instanceof String)) {
            throw new BadValueException("The 'to' field for $rename must be a string: " + key + ": " + toField);
        }
        String newKey = (String)toField;
        this.assertNotKeyField(newKey);
        if (this.renames.containsKey(key) || this.renames.containsValue(key)) {
            throw new ConflictingUpdateOperatorsException(key, key);
        }
        if (this.renames.containsKey(newKey) || this.renames.containsValue(newKey)) {
            throw new ConflictingUpdateOperatorsException(newKey, newKey);
        }
        this.renames.put(key, newKey);
    }

    private void applyRenames() {
        for (Map.Entry<String, String> entry : this.renames.entrySet()) {
            if (!Utils.canFullyTraverseSubkeyForRename(this.document, entry.getKey())) {
                throw new PathNotViableException("cannot traverse element");
            }
            Object value = Utils.removeSubdocumentValue((Object)this.document, entry.getKey(), this.matchPos);
            if (value instanceof Missing) continue;
            this.changeSubdocumentValue(this.document, entry.getValue(), value);
        }
    }

    private static List<Object> asList(Object value) {
        return (List)value;
    }

    private void changeSubdocumentValue(Document document, String key, Object newValue) {
        Utils.changeSubdocumentValue((Object)document, key, newValue, this.matchPos);
    }

    private Object getSubdocumentValue(Object document, String key) {
        return FieldUpdates.getSubdocumentValue(document, key, new AtomicReference<Integer>(this.matchPos));
    }

    private static Object getSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.getFieldValueListSafe(document, mainKey);
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return FieldUpdates.getSubdocumentValue(subObject, subKey, matchPos);
        }
        return Missing.getInstance();
    }

    private boolean shouldChangeValue(Object oldValue, Object newValue) {
        if (oldValue instanceof Missing) {
            return true;
        }
        int typeComparison = ValueComparator.compareTypes(newValue, oldValue);
        if (typeComparison != 0) {
            if (this.updateOperator == UpdateOperator.MAX) {
                return typeComparison > 0;
            }
            return typeComparison < 0;
        }
        ValueComparator valueComparator = this.updateOperator == UpdateOperator.MIN ? ValueComparator.asc() : ValueComparator.desc();
        int valueComparison = valueComparator.compare(newValue, oldValue);
        return valueComparison < 0;
    }

    private boolean isUpsert() {
        return this.upsert;
    }
}

