/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayFilters {
    private final Map<String, Object> values;

    private ArrayFilters(Map<String, Object> values) {
        this.values = values;
    }

    static ArrayFilters parse(Document query, Document updateQuery) {
        List<Document> arrayFilters = query.getOrDefault("arrayFilters", Collections.emptyList());
        return ArrayFilters.parse(arrayFilters, updateQuery);
    }

    private static ArrayFilters parse(List<Document> arrayFilters, Document updateQuery) {
        LinkedHashMap<String, Object> arrayFilterMap = new LinkedHashMap<String, Object>();
        for (Document arrayFilter : arrayFilters) {
            if (arrayFilter.isEmpty()) {
                throw new FailedToParseException("Cannot use an expression without a top-level field name in arrayFilters");
            }
            if (arrayFilter.size() > 1) {
                ArrayList<String> keys = new ArrayList<String>(arrayFilter.keySet());
                throw new FailedToParseException("Error parsing array filter :: caused by :: Expected a single top-level field name, found '" + (String)keys.get(0) + "' and '" + (String)keys.get(1) + "'");
            }
            Map.Entry<String, Object> entry = arrayFilter.entrySet().iterator().next();
            String identifier = entry.getKey();
            if (!identifier.matches("^[a-zA-Z0-9]+$")) {
                throw new BadValueException("Error parsing array filter :: caused by :: The top-level field name must be an alphanumeric string beginning with a lowercase letter, found '" + identifier + "'");
            }
            Object value = entry.getValue();
            if (arrayFilterMap.put(identifier, value) == null) continue;
            throw new FailedToParseException("Found multiple array filters with the same top-level field name " + identifier);
        }
        if (!arrayFilterMap.isEmpty()) {
            ArrayFilters.validate(updateQuery, arrayFilterMap);
        }
        return new ArrayFilters(arrayFilterMap);
    }

    private static void validate(Document updateQuery, Map<String, Object> arrayFilterMap) {
        Set allKeys = updateQuery.values().stream().filter(Document.class::isInstance).map(Document.class::cast).flatMap(d -> d.keySet().stream()).collect(Collectors.toSet());
        for (String identifier : arrayFilterMap.keySet()) {
            if (!allKeys.stream().noneMatch(key -> key.contains(ArrayFilters.toOperator(identifier)))) continue;
            throw new FailedToParseException("The array filter for identifier '" + identifier + "' was not used in the update " + updateQuery.toString(true, "{ ", " }"));
        }
    }

    public static ArrayFilters empty() {
        return new ArrayFilters(Collections.emptyMap());
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return Json.toJsonValue(new Document(this.values));
    }

    public boolean contains(String key) {
        return this.values.keySet().stream().map(ArrayFilters::toOperator).anyMatch(key::contains);
    }

    private Object getArrayFilterQuery(String key) {
        return this.values.get(ArrayFilters.fromOperator(key));
    }

    private static String toOperator(String identifier) {
        return "$[" + identifier + "]";
    }

    private static String fromOperator(String key) {
        if (!key.startsWith("$[") || !key.endsWith("]")) {
            throw new IllegalArgumentException("Illegal key: " + key);
        }
        return key.substring("$[".length(), key.length() - "]".length());
    }

    List<String> calculateKeys(Document document, String key) {
        int pos = key.indexOf(".$[");
        if (pos <= 0) {
            throw new BadValueException("Cannot have array filter identifier (i.e. '$[<id>]') element in the first position in path '" + key + "'");
        }
        String path = key.substring(0, pos);
        String subKey = key.substring(pos + 1);
        Object subObject = Utils.getSubdocumentValue(document, path);
        if (subObject instanceof Missing) {
            throw new BadValueException("The path '" + path + "' must exist in the document in order to apply array updates.");
        }
        if (!(subObject instanceof List)) {
            throw new BadValueException("Cannot apply array updates to non-array element grades: " + Json.toJsonValue(subObject) + "'");
        }
        Object arrayFilterQuery = this.getArrayFilterQuery(subKey);
        List values = (List)subObject;
        DefaultQueryMatcher queryMatcher = new DefaultQueryMatcher();
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            if (!queryMatcher.matchesValue(arrayFilterQuery, values.get(i))) continue;
            keys.add(path + "." + i);
        }
        return keys;
    }
}

