/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKField;
import de.brendamour.jpasskit.PKSemantics;
import de.brendamour.jpasskit.enums.PKDataDetectorType;
import de.brendamour.jpasskit.enums.PKDateStyle;
import de.brendamour.jpasskit.enums.PKNumberStyle;
import de.brendamour.jpasskit.enums.PKTextAlignment;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

@JsonPOJOBuilder(withPrefix="")
public class PKFieldBuilder
implements IPKValidateable,
IPKBuilder<PKField> {
    private PKField field = new PKField();
    private List<PKDataDetectorType> dataDetectorTypes = new CopyOnWriteArrayList<PKDataDetectorType>();

    protected PKFieldBuilder() {
    }

    public PKFieldBuilder of(PKField source) {
        if (source != null) {
            this.field = source.clone();
            this.dataDetectorTypes = this.field.dataDetectorTypes == null ? new CopyOnWriteArrayList<PKDataDetectorType>() : new CopyOnWriteArrayList<PKDataDetectorType>(this.field.dataDetectorTypes);
        }
        return this;
    }

    public PKFieldBuilder key(String key) {
        this.field.key = key;
        return this;
    }

    public PKFieldBuilder label(String label) {
        this.field.label = label;
        return this;
    }

    public PKFieldBuilder value(String value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(Integer value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(Float value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(Long value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(Double value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(BigDecimal value) {
        this.field.value = value;
        return this;
    }

    @Deprecated
    public PKFieldBuilder value(Date value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder value(Instant value) {
        this.field.value = value;
        return this;
    }

    @JsonProperty(value="value")
    protected PKFieldBuilder value(Serializable value) {
        this.field.value = value;
        return this;
    }

    public PKFieldBuilder changeMessage(String changeMessage) {
        this.field.changeMessage = changeMessage;
        return this;
    }

    public PKFieldBuilder textAlignment(PKTextAlignment textAlignment) {
        this.field.textAlignment = textAlignment;
        return this;
    }

    public PKFieldBuilder currencyCode(String currencyCode) {
        this.field.currencyCode = currencyCode;
        return this;
    }

    public PKFieldBuilder numberStyle(PKNumberStyle numberStyle) {
        this.field.numberStyle = numberStyle;
        return this;
    }

    public PKFieldBuilder dateStyle(PKDateStyle dateStyle) {
        this.field.dateStyle = dateStyle;
        return this;
    }

    public PKFieldBuilder timeStyle(PKDateStyle timeStyle) {
        this.field.timeStyle = timeStyle;
        return this;
    }

    public PKFieldBuilder isRelative(Boolean isRelative) {
        this.field.isRelative = isRelative;
        return this;
    }

    public PKFieldBuilder attributedValue(Serializable attributedValue) {
        this.field.attributedValue = attributedValue;
        return this;
    }

    public PKFieldBuilder dataDetectorType(PKDataDetectorType dataDetectorType) {
        this.dataDetectorTypes.add(dataDetectorType);
        return this;
    }

    public PKFieldBuilder dataDetectorTypes(List<PKDataDetectorType> dataDetectorTypes) {
        if (dataDetectorTypes == null || dataDetectorTypes.isEmpty()) {
            this.dataDetectorTypes.clear();
            return this;
        }
        this.dataDetectorTypes.addAll(dataDetectorTypes);
        return this;
    }

    public PKFieldBuilder ignoresTimeZone(Boolean ignoresTimeZone) {
        this.field.ignoresTimeZone = ignoresTimeZone;
        return this;
    }

    public PKFieldBuilder row(Integer row) {
        this.field.row = row;
        return this;
    }

    public PKFieldBuilder semantics(PKSemantics semantics) {
        this.field.semantics = semantics;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        this.checkRequiredFields(validationErrors);
        this.checkValueType(validationErrors);
        this.checkCurrencyCodeAndNumberStyleAreNotBothSet(validationErrors);
        this.checkNumberOrCurrencyAndDateNotSetAtTheSameTime(validationErrors);
        this.checkCurrencyValueIsNumeric(validationErrors);
        return validationErrors;
    }

    private void checkCurrencyValueIsNumeric(List<String> validationErrors) {
        if (this.field.currencyCode != null && !PKFieldBuilder.isNumeric(this.field.value)) {
            validationErrors.add("Field 'currencyCode' must be set only for numeric types. When using currencies, the values have to be numbers");
        }
    }

    private void checkNumberOrCurrencyAndDateNotSetAtTheSameTime(List<String> validationErrors) {
        if (!(this.field.currencyCode == null && this.field.numberStyle == null || this.field.dateStyle == null && this.field.timeStyle == null)) {
            validationErrors.add("Either 'currencyCode' or 'numberStyle' are set along with 'dateStyle' and/or 'timeStyle'. PKField cannot be number/currency and date at the same time");
        }
    }

    private void checkCurrencyCodeAndNumberStyleAreNotBothSet(List<String> validationErrors) {
        if (this.field.currencyCode != null && this.field.numberStyle != null) {
            validationErrors.add("Fields currencyCode and numberStyle are both set. PKField cannot be number and currency at the same time");
        }
    }

    private void checkValueType(List<String> validationErrors) {
        if (!(this.field.value instanceof String || PKFieldBuilder.isNumeric(this.field.value) || this.field.value instanceof Date || this.field.value instanceof Instant)) {
            validationErrors.add("Invalid value type. Allowed: String, Integer, Float, Long, Double, java.util.Date, Instant, BigDecimal");
        }
    }

    private void checkRequiredFields(List<String> validationErrors) {
        if (this.field.value == null || StringUtils.isEmpty((CharSequence)this.field.key)) {
            validationErrors.add("Not all required fields are set. Key: " + this.field.key + " Value: " + this.field.value);
        }
    }

    @Override
    public PKField build() {
        if (!this.dataDetectorTypes.isEmpty()) {
            this.field.dataDetectorTypes = Collections.unmodifiableList(this.dataDetectorTypes);
        }
        return this.field;
    }

    private static boolean isNumeric(Serializable value) {
        return value instanceof Integer || value instanceof Float || value instanceof Long || value instanceof Double || value instanceof BigDecimal;
    }
}

