/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import de.brendamour.jpasskit.util.CertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PKSigningInformationUtil {
    public PKSigningInformation loadSigningInformation(String keyStoreFilePath, String keyStorePassword, String appleWWDRCAFilePath) throws PKSigningException {
        try {
            return this.loadSigningInformationFromPKCS12AndIntermediateCertificate(keyStoreFilePath, keyStorePassword, appleWWDRCAFilePath);
        }
        catch (IOException | CertificateException e) {
            throw new PKSigningException("Failed to load signing information", e);
        }
    }

    /*
     * Exception decompiling
     */
    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(String keyPath, String keyPassword, String appleWWDRCAFilePath) throws IOException, CertificateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(InputStream keyStoreInputStream, String keyStorePassword, InputStream appleWWDRCAFileInputStream) throws IOException, CertificateException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(keyStoreInputStream, keyStorePassword);
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFileInputStream);
        return this.loadSigningInformation(pkcs12KeyStore, keyStorePassword, appleWWDRCACert);
    }

    private PKSigningInformation loadSigningInformation(KeyStore keyStore, String keyStorePassword, X509Certificate appleWWDRCACert) throws IOException, CertificateException {
        ImmutablePair<PrivateKey, X509Certificate> pair = CertUtils.extractCertificateWithKey(keyStore, keyStorePassword.toCharArray());
        return this.checkCertsAndReturnSigningInformationObject((PrivateKey)pair.getLeft(), (X509Certificate)pair.getRight(), appleWWDRCACert);
    }

    @Deprecated
    public KeyStore loadPKCS12File(String pathToP12, String password) throws CertificateException, IOException {
        try (InputStream keystoreInputStream = CertUtils.toInputStream(pathToP12);){
            KeyStore keyStore = this.loadPKCS12File(keystoreInputStream, password);
            return keyStore;
        }
    }

    @Deprecated
    public KeyStore loadPKCS12File(InputStream inputStreamOfP12, String password) throws CertificateException, IOException {
        try {
            return CertUtils.toKeyStore(inputStreamOfP12, password.toCharArray());
        }
        catch (IllegalStateException ex) {
            throw new IOException("Key from the input stream could not be decrypted", ex);
        }
    }

    @Deprecated
    public X509Certificate loadDERCertificate(String filePath) throws IOException, CertificateException {
        try (InputStream certificateInputStream = CertUtils.toInputStream(filePath);){
            X509Certificate x509Certificate = this.loadDERCertificate(certificateInputStream);
            return x509Certificate;
        }
    }

    @Deprecated
    public X509Certificate loadDERCertificate(InputStream certificateInputStream) throws IOException, CertificateException {
        try {
            return CertUtils.toX509Certificate(certificateInputStream);
        }
        catch (IllegalStateException ex) {
            throw new IOException("Certificate from the input stream could not be decrypted", ex);
        }
    }

    private PKSigningInformation checkCertsAndReturnSigningInformationObject(PrivateKey signingPrivateKey, X509Certificate signingCert, X509Certificate appleWWDRCACert) throws IOException, CertificateException {
        if (signingCert == null || signingPrivateKey == null || appleWWDRCACert == null) {
            throw new IOException("Couldn't load all the necessary certificates/keys.");
        }
        appleWWDRCACert.checkValidity();
        signingCert.checkValidity();
        return new PKSigningInformation(signingCert, signingPrivateKey, appleWWDRCACert);
    }
}

