/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import de.brendamour.jpasskit.signing.IPKPassTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKPassTemplateFolder
implements IPKPassTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKPassTemplateFolder.class);
    private File templateDir;

    public PKPassTemplateFolder(URL fileUrlOfTemplateDirectory) throws UnsupportedEncodingException {
        this(URLDecoder.decode(fileUrlOfTemplateDirectory.getFile(), "UTF-8"));
    }

    public PKPassTemplateFolder(String pathToTemplateDirectory) {
        LOGGER.info("Specified template directory: {}", (Object)pathToTemplateDirectory);
        this.templateDir = new File(pathToTemplateDirectory);
    }

    @Override
    public void provisionPassAtDirectory(File tempPassDir) throws IOException {
        FileUtils.copyDirectory((File)this.templateDir, (File)tempPassDir);
    }

    @Override
    public Map<String, ByteBuffer> getAllFiles() throws IOException {
        HashMap<String, ByteBuffer> allFiles = new HashMap<String, ByteBuffer>();
        String base = this.templateDir.getCanonicalPath();
        for (File file : FileUtils.listFiles((File)this.templateDir, (IOFileFilter)new RegexFileFilter("^(?!\\.).*"), (IOFileFilter)TrueFileFilter.TRUE)) {
            byte[] byteArray = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            String filePath = file.getCanonicalPath().substring(base.length() + 1);
            LOGGER.debug("File's own path: {}", (Object)filePath);
            allFiles.put(filePath, ByteBuffer.wrap(byteArray));
        }
        return allFiles;
    }
}

