/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.apns;

import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import com.turo.pushy.apns.util.TokenUtil;
import com.turo.pushy.apns.util.concurrent.PushNotificationFuture;
import com.turo.pushy.apns.util.concurrent.PushNotificationResponseListener;
import de.brendamour.jpasskit.util.Assert;
import de.brendamour.jpasskit.util.CertUtils;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKSendPushNotificationUtil
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKSendPushNotificationUtil.class);
    private static final String EMPTY_PUSH_JSON_STRING = "{}";
    private static final int POOL_SIZE_DEFAULT = 10;
    private ApnsClient client;
    private Set<String> topics;

    public PKSendPushNotificationUtil(String keyStorePath, char[] keyStorePassword) throws IOException {
        this(keyStorePath, keyStorePassword, 10);
    }

    public PKSendPushNotificationUtil(String keyStorePath, char[] keyStorePassword, int poolSize) throws IOException {
        try (InputStream keyStoreInputStream = CertUtils.toInputStream(keyStorePath);){
            KeyStore keyStore = CertUtils.toKeyStore(keyStoreInputStream, keyStorePassword);
            ImmutablePair<PrivateKey, X509Certificate> certificate = CertUtils.extractCertificateWithKey(keyStore, keyStorePassword);
            this.client = new ApnsClientBuilder().setApnsServer("api.push.apple.com", 443).setClientCredentials((X509Certificate)certificate.getRight(), (PrivateKey)certificate.getLeft(), String.valueOf(keyStorePassword)).setConcurrentConnections(poolSize).build();
            this.topics = CertUtils.extractApnsTopics((X509Certificate)certificate.getRight());
        }
        catch (CertificateException ex) {
            throw new IOException("Failed to load keystore from " + keyStorePath);
        }
    }

    @Deprecated
    public PKSendPushNotificationUtil(String keyStorePath, String keyStorePassword) throws IOException {
        this(keyStorePath, keyStorePassword == null ? null : keyStorePassword.toCharArray());
    }

    @Deprecated
    public PKSendPushNotificationUtil(String keyStorePath, String keyStorePassword, int poolSize) throws IOException {
        this(keyStorePath, keyStorePassword == null ? null : keyStorePassword.toCharArray(), poolSize);
    }

    public void setClient(ApnsClient client) {
        this.client = client;
    }

    @Deprecated
    public void sendPushNotification(String pushtoken) {
        try {
            PushNotificationFuture<SimpleApnsPushNotification, PushNotificationResponse<SimpleApnsPushNotification>> notificationFuture = this.sendPushNotificationAsync(pushtoken);
            notificationFuture.addListener((GenericFutureListener)new ApnsLoggingDelegate());
            PushNotificationResponse pushNotificationResponse = (PushNotificationResponse)notificationFuture.get();
            if (pushNotificationResponse.isAccepted()) {
                LOGGER.debug("Push notification accepted by APNs gateway.");
            } else {
                LOGGER.debug("Notification rejected by the APNs gateway: {}", (Object)pushNotificationResponse.getRejectionReason());
                if (pushNotificationResponse.getTokenInvalidationTimestamp() != null) {
                    LOGGER.debug("\t\u2026and the token is invalid as of {}", (Object)pushNotificationResponse.getTokenInvalidationTimestamp());
                }
            }
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to send push notification.", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to send push notification.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public PushNotificationFuture<SimpleApnsPushNotification, PushNotificationResponse<SimpleApnsPushNotification>> sendPushNotificationAsync(String pushtoken) {
        LOGGER.debug("Sending Push notification for key: {}", (Object)pushtoken);
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        payloadBuilder.setAlertBody(EMPTY_PUSH_JSON_STRING);
        String payload = payloadBuilder.buildWithDefaultMaximumLength();
        String token = TokenUtil.sanitizeTokenString((String)pushtoken);
        Assert.state(!this.topics.isEmpty(), "APNS topic is required for sending a push notification", new Object[0]);
        String topic = null;
        if (!this.topics.isEmpty()) {
            topic = this.topics.iterator().next();
            if (this.topics.size() > 1) {
                LOGGER.warn("Multiple APNS topics detected, using {} (first value out of {} available) for sending a push notification", (Object)topic, (Object)this.topics.size());
            }
        }
        SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, topic, payload);
        LOGGER.debug("Send Push notification for key: {}", (Object)pushtoken);
        return this.client.sendNotification((ApnsPushNotification)pushNotification);
    }

    @Deprecated
    public void sendMultiplePushNotifications(List<String> pushtokens) {
        LOGGER.debug("Sending Push notification for keys: {}", pushtokens);
        for (String token : pushtokens) {
            this.sendPushNotification(token);
        }
    }

    @Override
    public void close() throws InterruptedException {
        if (this.client != null) {
            this.client.close().await();
        }
    }

    class ApnsLoggingDelegate
    implements PushNotificationResponseListener<SimpleApnsPushNotification> {
        ApnsLoggingDelegate() {
        }

        public void operationComplete(PushNotificationFuture<SimpleApnsPushNotification, PushNotificationResponse<SimpleApnsPushNotification>> future) throws Exception {
            if (future.isSuccess()) {
                LOGGER.debug("Successfully sent");
            } else {
                LOGGER.error("Error sending push notification", future.cause());
            }
        }
    }
}

