/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import de.brendamour.jpasskit.signing.PKFileBasedSigningUtil;
import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKSigningInformationUtil {
    public PKSigningInformationUtil() {
        this.addBCProvider();
    }

    public PKSigningInformation loadSigningInformation(String pkcs12KeyStoreFilePath, String keyStorePassword, String appleWWDRCAFilePath) throws PKSigningException {
        try {
            return this.loadSigningInformationFromPKCS12AndIntermediateCertificate(pkcs12KeyStoreFilePath, keyStorePassword, appleWWDRCAFilePath);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new PKSigningException("Failed to load signing information", e);
        }
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(String pkcs12KeyStoreFilePath, String keyStorePassword, String appleWWDRCAFilePath) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(pkcs12KeyStoreFilePath, keyStorePassword);
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFilePath);
        return this.loadSigningInformationFromPKCS12AndIntermediateCertificate(pkcs12KeyStore, keyStorePassword.toCharArray(), appleWWDRCACert);
    }

    public PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(InputStream pkcs12KeyStoreInputStream, String keyStorePassword, InputStream appleWWDRCAFileInputStream) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        KeyStore pkcs12KeyStore = this.loadPKCS12File(pkcs12KeyStoreInputStream, keyStorePassword);
        X509Certificate appleWWDRCACert = this.loadDERCertificate(appleWWDRCAFileInputStream);
        return this.loadSigningInformationFromPKCS12AndIntermediateCertificate(pkcs12KeyStore, keyStorePassword.toCharArray(), appleWWDRCACert);
    }

    private PKSigningInformation loadSigningInformationFromPKCS12AndIntermediateCertificate(KeyStore pkcs12KeyStore, char[] keyStorePassword, X509Certificate appleWWDRCACert) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        Enumeration<String> aliases = pkcs12KeyStore.aliases();
        PrivateKey signingPrivateKey = null;
        X509Certificate signingCert = null;
        while (aliases.hasMoreElements()) {
            String aliasName = aliases.nextElement();
            Key key = pkcs12KeyStore.getKey(aliasName, keyStorePassword);
            if (!(key instanceof PrivateKey)) continue;
            signingPrivateKey = (PrivateKey)key;
            Certificate cert = pkcs12KeyStore.getCertificate(aliasName);
            if (!(cert instanceof X509Certificate)) continue;
            signingCert = (X509Certificate)cert;
            break;
        }
        return this.checkCertsAndReturnSigningInformationObject(signingPrivateKey, signingCert, appleWWDRCACert);
    }

    public KeyStore loadPKCS12File(String pathToP12, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        File p12File = new File(pathToP12);
        if (!p12File.exists()) {
            URL localP12File = PKFileBasedSigningUtil.class.getClassLoader().getResource(pathToP12);
            if (localP12File == null) {
                throw new FileNotFoundException("File at " + pathToP12 + " not found");
            }
            p12File = new File(localP12File.getFile());
        }
        try (FileInputStream streamOfFile = new FileInputStream(p12File);){
            KeyStore keyStore = this.loadPKCS12File(streamOfFile, password);
            return keyStore;
        }
    }

    public KeyStore loadPKCS12File(InputStream inputStreamOfP12, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (inputStreamOfP12 == null) {
            throw new IllegalArgumentException("InputStream of key store must not be null");
        }
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(inputStreamOfP12, password.toCharArray());
        return keystore;
    }

    public X509Certificate loadDERCertificate(String filePath) throws IOException, CertificateException {
        File certFile = new File(filePath);
        if (!certFile.exists()) {
            URL localCertFile = PKFileBasedSigningUtil.class.getClassLoader().getResource(filePath);
            if (localCertFile == null) {
                throw new FileNotFoundException("File at " + filePath + " not found");
            }
            certFile = new File(localCertFile.getFile());
        }
        try (FileInputStream certificateFileInputStream = new FileInputStream(certFile);){
            X509Certificate x509Certificate = this.loadDERCertificate(certificateFileInputStream);
            return x509Certificate;
        }
    }

    public X509Certificate loadDERCertificate(InputStream certificateInputStream) throws IOException, CertificateException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            Certificate certificate = certificateFactory.generateCertificate(certificateInputStream);
            if (certificate instanceof X509Certificate) {
                ((X509Certificate)certificate).checkValidity();
                return (X509Certificate)certificate;
            }
            throw new IOException("The key from the input stream could not be decrypted");
        }
        catch (IOException ex) {
            throw new IOException("The key from the input stream could not be decrypted", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new IOException("The key from the input stream could not be decrypted", ex);
        }
    }

    private PKSigningInformation checkCertsAndReturnSigningInformationObject(PrivateKey signingPrivateKey, X509Certificate signingCert, X509Certificate appleWWDRCACert) throws IOException, CertificateExpiredException, CertificateNotYetValidException {
        if (signingCert == null || signingPrivateKey == null || appleWWDRCACert == null) {
            throw new IOException("Couldn't load all the neccessary certificates/keys.");
        }
        appleWWDRCACert.checkValidity();
        signingCert.checkValidity();
        return new PKSigningInformation(signingCert, signingPrivateKey, appleWWDRCACert);
    }

    private void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

