/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.PKPass;
import de.brendamour.jpasskit.signing.IPKSigningUtil;
import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import java.io.File;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public abstract class PKAbstractSigningUtil
implements IPKSigningUtil {
    protected static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    protected static final String PASS_JSON_FILE_NAME = "pass.json";
    protected static final String PERSONALIZATION_JSON_FILE_NAME = "personalization.json";
    protected static final String SIGNATURE_FILE_NAME = "signature";
    protected ObjectWriter objectWriter;

    protected PKAbstractSigningUtil(ObjectMapper objectMapper) {
        this.addBCProvider();
        this.objectWriter = this.configureObjectMapper(objectMapper);
    }

    protected PKAbstractSigningUtil(ObjectWriter objectWriter) {
        this.addBCProvider();
        this.objectWriter = objectWriter;
    }

    @Override
    public byte[] signManifestFile(byte[] manifestJSON, PKSigningInformation signingInformation) throws PKSigningException {
        if (manifestJSON == null) {
            throw new IllegalArgumentException("manifestJSON has tobe present");
        }
        CMSProcessableByteArray content = new CMSProcessableByteArray(manifestJSON);
        return this.signManifestUsingContent(signingInformation, (CMSTypedData)content);
    }

    protected byte[] signManifestUsingContent(PKSigningInformation signingInformation, CMSTypedData content) throws PKSigningException {
        if (signingInformation == null || !signingInformation.isValid()) {
            throw new IllegalArgumentException("Signing information not valid");
        }
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(signingInformation.getSigningPrivateKey());
            ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
            Attribute signingAttribute = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new DERUTCTime(new Date())));
            signedAttributes.add((ASN1Encodable)signingAttribute);
            AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
            DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributesTable);
            generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator).build(sha1Signer, signingInformation.getSigningCert()));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(signingInformation.getAppleWWDRCACert());
            certList.add(signingInformation.getSigningCert());
            JcaCertStore certs = new JcaCertStore(certList);
            generator.addCertificates((Store)certs);
            CMSSignedData sigData = generator.generate(content, false);
            return sigData.getEncoded();
        }
        catch (Exception e) {
            throw new PKSigningException("Error when signing manifest", e);
        }
    }

    protected ObjectWriter configureObjectMapper(ObjectMapper jsonObjectMapper) {
        jsonObjectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        jsonObjectMapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        SimpleFilterProvider filters = new SimpleFilterProvider();
        filters.addFilter("validateFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors"}));
        filters.addFilter("pkPassFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors", "foregroundColorAsObject", "backgroundColorAsObject", "labelColorAsObject", "passThatWasSet"}));
        filters.addFilter("barcodeFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"valid", "validationErrors", "messageEncodingAsString", "validInIosVersionsBefore9"}));
        filters.addFilter("charsetFilter", SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"name"}));
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonObjectMapper.addMixIn(Object.class, ValidateFilterMixIn.class);
        jsonObjectMapper.addMixIn(PKPass.class, PkPassFilterMixIn.class);
        jsonObjectMapper.addMixIn(PKBarcode.class, BarcodeFilterMixIn.class);
        jsonObjectMapper.addMixIn(Charset.class, CharsetFilterMixIn.class);
        return jsonObjectMapper.writer((FilterProvider)filters);
    }

    protected String getRelativePathOfZipEntry(String fileCanonicalPath, String baseCanonicalPath) {
        String relativePathOfFile = fileCanonicalPath.substring(baseCanonicalPath.length());
        if (File.separatorChar != '/') {
            relativePathOfFile = relativePathOfFile.replace(File.separatorChar, '/');
        }
        return relativePathOfFile;
    }

    private void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    @JsonFilter(value="charsetFilter")
    protected class CharsetFilterMixIn {
        protected CharsetFilterMixIn() {
        }
    }

    @JsonFilter(value="barcodeFilter")
    protected class BarcodeFilterMixIn {
        protected BarcodeFilterMixIn() {
        }
    }

    @JsonFilter(value="validateFilter")
    protected class ValidateFilterMixIn {
        protected ValidateFilterMixIn() {
        }
    }

    @JsonFilter(value="pkPassFilter")
    protected class PkPassFilterMixIn {
        protected PkPassFilterMixIn() {
        }
    }
}

