/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.enums.PKDataDetectorType;
import de.brendamour.jpasskit.enums.PKDateStyle;
import de.brendamour.jpasskit.enums.PKNumberStyle;
import de.brendamour.jpasskit.enums.PKTextAlignment;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PKField
implements IPKValidateable {
    private static final long serialVersionUID = -6362596567978565530L;
    private String key;
    private String label;
    private Object value;
    private Object attributedValue;
    private String changeMessage;
    private PKTextAlignment textAlignment;
    private List<PKDataDetectorType> dataDetectorTypes;
    private String currencyCode;
    private PKNumberStyle numberStyle;
    private PKDateStyle dateStyle;
    private PKDateStyle timeStyle;
    private Boolean isRelative;
    private Boolean ignoresTimeZone;

    public PKField() {
    }

    public PKField(String key, String label, Object value) {
        this.key = key;
        this.label = label;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getChangeMessage() {
        return this.changeMessage;
    }

    public void setChangeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
    }

    public PKTextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(PKTextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PKNumberStyle getNumberStyle() {
        return this.numberStyle;
    }

    public void setNumberStyle(PKNumberStyle numberStyle) {
        this.numberStyle = numberStyle;
    }

    public PKDateStyle getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(PKDateStyle dateStyle) {
        this.dateStyle = dateStyle;
    }

    public PKDateStyle getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(PKDateStyle timeStyle) {
        this.timeStyle = timeStyle;
    }

    public Boolean getIsRelative() {
        return this.isRelative;
    }

    public void setIsRelative(Boolean isRelative) {
        this.isRelative = isRelative;
    }

    public Object getAttributedValue() {
        return this.attributedValue;
    }

    public void setAttributedValue(Object attributedValue) {
        this.attributedValue = attributedValue;
    }

    public List<PKDataDetectorType> getDataDetectorTypes() {
        return this.dataDetectorTypes;
    }

    public void setDataDetectorTypes(List<PKDataDetectorType> dataDetectorTypes) {
        this.dataDetectorTypes = dataDetectorTypes;
    }

    public Boolean getIgnoresTimeZone() {
        return this.ignoresTimeZone;
    }

    public void setIgnoresTimeZone(Boolean ignoresTimeZone) {
        this.ignoresTimeZone = ignoresTimeZone;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.value == null || StringUtils.isEmpty((CharSequence)this.key)) {
            validationErrors.add("Not all required Fields are set. Key: " + this.key + " Value:" + this.value);
        }
        if (!(this.value instanceof String || this.value instanceof Integer || this.value instanceof Float || this.value instanceof Long || this.value instanceof Double || this.value instanceof Date || this.value instanceof BigDecimal)) {
            validationErrors.add("Invalid value type. Allowed: String, Integer, Float, Long, Double, java.util.Date, BigDecimal");
        }
        if (this.currencyCode != null && this.numberStyle != null) {
            validationErrors.add("CurrencyCode and numberStyle are both set");
        }
        if (!(this.currencyCode == null && this.numberStyle == null || this.dateStyle == null && this.timeStyle == null)) {
            validationErrors.add("Can't be number/currency and date at the same time");
        }
        if (this.changeMessage != null && !this.changeMessage.contains("%@")) {
            validationErrors.add("ChangeMessage needs to contain %@ placeholder");
        }
        if (!(this.currencyCode == null || this.value instanceof Integer || this.value instanceof Float || this.value instanceof Long || this.value instanceof Double || this.value instanceof BigDecimal)) {
            validationErrors.add("When using currencies, the values have to be numbers");
        }
        return validationErrors;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

