/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.PKBeacon;
import de.brendamour.jpasskit.PKLocation;
import de.brendamour.jpasskit.PKNFC;
import de.brendamour.jpasskit.PWAssociatedApp;
import de.brendamour.jpasskit.passes.PKBoardingPass;
import de.brendamour.jpasskit.passes.PKCoupon;
import de.brendamour.jpasskit.passes.PKEventTicket;
import de.brendamour.jpasskit.passes.PKGenericPass;
import de.brendamour.jpasskit.passes.PKStoreCard;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PKPass
implements IPKValidateable {
    private static final long serialVersionUID = -1727648896679270606L;
    private static final int EXPECTED_AUTHTOKEN_LENGTH = 16;
    private int formatVersion = 1;
    private String serialNumber;
    private String passTypeIdentifier;
    private URL webServiceURL;
    private String authenticationToken;
    private String description;
    private String teamIdentifier;
    private String organizationName;
    private String logoText;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color labelColor;
    private String groupingIdentifier;
    private List<PKBeacon> beacons;
    private List<PKLocation> locations;
    @Deprecated
    private PKBarcode barcode;
    private List<PKBarcode> barcodes;
    private PKEventTicket eventTicket;
    private PKCoupon coupon;
    private PKStoreCard storeCard;
    private PKBoardingPass boardingPass;
    private PKGenericPass generic;
    private PKGenericPass passThatWasSet;
    private String appLaunchURL;
    private List<Long> associatedStoreIdentifiers;
    private List<PWAssociatedApp> associatedApps;
    private String userInfo;
    private Long maxDistance;
    private Date relevantDate;
    private Date expirationDate;
    private Boolean voided;
    @Deprecated
    private Boolean suppressStripShine;
    private PKNFC nfc;

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getPassTypeIdentifier() {
        return this.passTypeIdentifier;
    }

    public void setPassTypeIdentifier(String passTypeIdentifier) {
        this.passTypeIdentifier = passTypeIdentifier;
    }

    public URL getWebServiceURL() {
        return this.webServiceURL;
    }

    public void setWebServiceURL(URL webServiceURL) {
        this.webServiceURL = webServiceURL;
    }

    public String getAppLaunchURL() {
        return this.appLaunchURL;
    }

    public void setAppLaunchURL(String appLaunchURL) {
        this.appLaunchURL = appLaunchURL;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTeamIdentifier() {
        return this.teamIdentifier;
    }

    public void setTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
    }

    public Boolean isVoided() {
        return this.voided;
    }

    public void setVoided(Boolean voided) {
        this.voided = voided;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public String getLogoText() {
        return this.logoText;
    }

    public void setLogoText(String logoText) {
        this.logoText = logoText;
    }

    public String getForegroundColor() {
        return this.convertColorToString(this.foregroundColor);
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = this.convertStringToColor(foregroundColor);
    }

    public String getBackgroundColor() {
        return this.convertColorToString(this.backgroundColor);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = this.convertStringToColor(backgroundColor);
    }

    public Color getForegroundColorAsObject() {
        return this.foregroundColor;
    }

    public void setForegroundColorAsObject(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getBackgroundColorAsObject() {
        return this.backgroundColor;
    }

    public void setBackgroundColorAsObject(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public List<PKBeacon> getBeacons() {
        return this.beacons;
    }

    public void setBeacons(List<PKBeacon> beacons) {
        this.beacons = beacons;
    }

    public Long getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(Long maxDistance) {
        this.maxDistance = maxDistance;
    }

    public List<PKLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<PKLocation> locations) {
        this.locations = locations;
    }

    @Deprecated
    public PKBarcode getBarcode() {
        return this.barcode;
    }

    @Deprecated
    public void setBarcode(PKBarcode barcode) {
        this.barcode = barcode;
    }

    public List<PKBarcode> getBarcodes() {
        return this.barcodes;
    }

    public void setBarcodes(List<PKBarcode> barcodes) {
        this.barcodes = barcodes;
    }

    public PKEventTicket getEventTicket() {
        return this.eventTicket;
    }

    public void setEventTicket(PKEventTicket eventTicket) {
        this.eventTicket = eventTicket;
        this.passThatWasSet = eventTicket;
        this.storeCard = null;
        this.coupon = null;
        this.generic = null;
        this.boardingPass = null;
    }

    public PKCoupon getCoupon() {
        return this.coupon;
    }

    public void setCoupon(PKCoupon coupon) {
        this.coupon = coupon;
        this.eventTicket = null;
        this.storeCard = null;
        this.generic = null;
        this.boardingPass = null;
        this.passThatWasSet = coupon;
    }

    public PKStoreCard getStoreCard() {
        return this.storeCard;
    }

    public void setStoreCard(PKStoreCard storeCard) {
        this.storeCard = storeCard;
        this.eventTicket = null;
        this.coupon = null;
        this.generic = null;
        this.boardingPass = null;
        this.passThatWasSet = storeCard;
    }

    public PKBoardingPass getBoardingPass() {
        return this.boardingPass;
    }

    public void setBoardingPass(PKBoardingPass boardingPass) {
        this.boardingPass = boardingPass;
        this.eventTicket = null;
        this.storeCard = null;
        this.coupon = null;
        this.generic = null;
        this.passThatWasSet = boardingPass;
    }

    public PKGenericPass getGeneric() {
        return this.generic;
    }

    public void setGeneric(PKGenericPass generic) {
        this.generic = generic;
        this.eventTicket = null;
        this.storeCard = null;
        this.coupon = null;
        this.boardingPass = null;
        this.passThatWasSet = generic;
    }

    public PKGenericPass getPassThatWasSet() {
        return this.passThatWasSet;
    }

    public String getLabelColor() {
        return this.convertColorToString(this.labelColor);
    }

    public void setLabelColor(String labelColor) {
        this.labelColor = this.convertStringToColor(labelColor);
    }

    public Color getLabelColorAsObject() {
        return this.labelColor;
    }

    public void setLabelColorAsObject(Color labelColor) {
        this.labelColor = labelColor;
    }

    public String getGroupingIdentifier() {
        return this.groupingIdentifier;
    }

    public void setGroupingIdentifier(String groupingIdentifier) {
        this.groupingIdentifier = groupingIdentifier;
    }

    public List<Long> getAssociatedStoreIdentifiers() {
        return this.associatedStoreIdentifiers;
    }

    public void setAssociatedStoreIdentifiers(List<Long> associatedStoreIdentifiers) {
        this.associatedStoreIdentifiers = associatedStoreIdentifiers;
    }

    public List<PWAssociatedApp> getAssociatedApps() {
        return this.associatedApps;
    }

    public void setAssociatedApps(List<PWAssociatedApp> associatedApps) {
        this.associatedApps = associatedApps;
    }

    public Date getRelevantDate() {
        return this.relevantDate;
    }

    public void setRelevantDate(Date relevantDate) {
        this.relevantDate = relevantDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Deprecated
    public Boolean isSuppressStripShine() {
        return this.suppressStripShine;
    }

    @Deprecated
    public void setSuppressStripShine(Boolean suppressStripShine) {
        this.suppressStripShine = suppressStripShine != false ? suppressStripShine : null;
    }

    public PKNFC getNFC() {
        return this.nfc;
    }

    public void setNFC(PKNFC nfc) {
        this.nfc = nfc;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)this.serialNumber) || StringUtils.isEmpty((CharSequence)this.passTypeIdentifier) || StringUtils.isEmpty((CharSequence)this.teamIdentifier) || StringUtils.isEmpty((CharSequence)this.description) || this.formatVersion == 0 || StringUtils.isEmpty((CharSequence)this.organizationName)) {
            validationErrors.add("Not all required Fields are set. SerialNumber" + this.serialNumber + " PassTypeIdentifier: " + this.passTypeIdentifier + " teamIdentifier" + this.teamIdentifier + " Description: " + this.description + " FormatVersion: " + this.formatVersion + " OrganizationName: " + this.organizationName);
        }
        if (this.passThatWasSet == null) {
            validationErrors.add("No pass was defined");
        }
        if (this.authenticationToken != null && this.authenticationToken.length() < 16) {
            validationErrors.add("The authenticationToken needs to be at least 16 long");
        }
        if (!this.passThatWasSet.isValid()) {
            validationErrors.addAll(this.passThatWasSet.getValidationErrors());
        }
        if (this.appLaunchURL != null && CollectionUtils.isEmpty(this.associatedStoreIdentifiers)) {
            validationErrors.add("The appLaunchURL requires associatedStoreIdentifiers to be specified");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.groupingIdentifier) && this.eventTicket == null && this.boardingPass == null) {
            validationErrors.add("The groupingIdentifier is optional for event tickets and boarding passes, otherwise not allowed");
        }
        return validationErrors;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    protected String convertColorToString(Color color) {
        if (color != null) {
            return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return null;
    }

    protected Color convertStringToColor(String colorString) {
        Color color = null;
        if (StringUtils.isNotBlank((CharSequence)colorString)) {
            String colorStringLower = colorString.trim().toLowerCase();
            if (colorStringLower.startsWith("rgb")) {
                String rgbValues = colorStringLower.replace("rgb(", "").replace(")", "");
                String[] rgbValuesArray = rgbValues.split(",");
                if (rgbValuesArray.length == 3) {
                    int r = Integer.parseInt(rgbValuesArray[0].trim());
                    int g = Integer.parseInt(rgbValuesArray[1].trim());
                    int b = Integer.parseInt(rgbValuesArray[2].trim());
                    color = new Color(r, g, b);
                }
            } else if (colorStringLower.startsWith("#")) {
                if (7 == colorStringLower.length()) {
                    int r = Integer.parseInt(colorStringLower.substring(1, 3), 16);
                    int g = Integer.parseInt(colorStringLower.substring(3, 5), 16);
                    int b = Integer.parseInt(colorStringLower.substring(5, 7), 16);
                    color = new Color(r, g, b);
                } else if (4 == colorStringLower.length()) {
                    int r = Integer.parseInt(colorStringLower.substring(1, 2) + colorStringLower.substring(1, 2), 16);
                    int g = Integer.parseInt(colorStringLower.substring(2, 3) + colorStringLower.substring(2, 3), 16);
                    int b = Integer.parseInt(colorStringLower.substring(3, 4) + colorStringLower.substring(3, 4), 16);
                    color = new Color(r, g, b);
                }
            }
        }
        return color;
    }
}

