/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.annotationprocessing;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class AnnotationProcessorProvider {
    private static final String RESOURCE_LOCATION = "META-INF/";
    private static final String RESOURCE_EXTENSION = ".processor";

    private AnnotationProcessorProvider() {
    }

    public static AnnotationProcessorProvider getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Optional<String> getProcessorClassName(String processorKey) {
        String resourceName = RESOURCE_LOCATION + processorKey + RESOURCE_EXTENSION;
        TreeMap<Integer, String> processorMap = new TreeMap<Integer, String>();
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(url));
                Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
                if (entrySet.isEmpty()) {
                    return Optional.empty();
                }
                Map.Entry<Object, Object> firstEntry = entrySet.iterator().next();
                processorMap.put(Integer.valueOf(firstEntry.getValue().toString()), firstEntry.getKey().toString());
            }
            return Optional.ofNullable(Iterables.getLast(processorMap.values(), null));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load processor from location [" + resourceName + "]", ex);
        }
    }

    private static class SingletonHolder {
        private static final AnnotationProcessorProvider INSTANCE = new AnnotationProcessorProvider();

        private SingletonHolder() {
        }
    }
}

