/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.layered;

import android.graphics.Canvas;
import android.graphics.Paint;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Layout;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.layered.SugiyamaConfiguration;
import de.blox.graphview.layered.SugiyamaEdgeData;
import de.blox.graphview.layered.SugiyamaEdgeRenderer;
import de.blox.graphview.layered.SugiyamaNodeData;
import de.blox.graphview.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001e\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J<\u0010 \u001a\u00020\u001e2\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n0\"2\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n0\"H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010'\u001a\u00020\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\nH\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014H\u0002J\u001c\u0010+\u001a\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\"0\"H\u0002J\b\u0010/\u001a\u00020\u001eH\u0002J\b\u00100\u001a\u00020\u001eH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0014H\u0002J \u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0016J&\u00108\u001a\u00020\u001e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u0014H\u0002J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u00102\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0014H\u0002J \u0010@\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0090\u0001\u0010A\u001a\u00020\u001e2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0006\u0010E\u001a\u00020>2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010F\u001a\u00020\u001eH\u0002J\u0010\u0010G\u001a\u00020>2\u0006\u0010:\u001a\u00020\u0014H\u0002J\b\u0010H\u001a\u00020\u001eH\u0002J\u001c\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0\"0\"2\u0006\u0010=\u001a\u00020>H\u0002J>\u0010J\u001a\u00020\u001e2,\u0010\u0011\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0013j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015`\u00152\u0006\u0010K\u001a\u00020\u0017H\u0002J\b\u0010L\u001a\u00020\u001eH\u0002J\u0090\u0001\u0010M\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u00142\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\n2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010E\u001a\u00020>H\u0002J\u0010\u0010N\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0014H\u0002J\u001a\u0010O\u001a\u0004\u0018\u00010\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010E\u001a\u00020>H\u0002J\b\u0010P\u001a\u00020\u001eH\u0002J\b\u0010Q\u001a\u00020\u001eH\u0002J \u0010R\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020#H\u0016J\u0010\u0010U\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020\u000eH\u0016J\u0018\u0010W\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020#2\u0006\u0010T\u001a\u00020#H\u0002J\u001c\u0010X\u001a\u00020\u001e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\"0\"H\u0002JT\u0010Y\u001a\u00020\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\n2\u0012\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0\"0\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010E\u001a\u00020>H\u0002J\u001a\u0010[\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00150\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lde/blox/graphview/layered/SugiyamaAlgorithm;", "Lde/blox/graphview/Layout;", "configuration", "Lde/blox/graphview/layered/SugiyamaConfiguration;", "(Lde/blox/graphview/layered/SugiyamaConfiguration;)V", "dummyText", "", "getDummyText", "()Ljava/lang/String;", "edgeData", "", "Lde/blox/graphview/Edge;", "Lde/blox/graphview/layered/SugiyamaEdgeData;", "edgeRenderer", "Lde/blox/graphview/edgerenderer/EdgeRenderer;", "graph", "Lde/blox/graphview/Graph;", "layers", "", "Ljava/util/ArrayList;", "Lde/blox/graphview/Node;", "Lkotlin/collections/ArrayList;", "nodeCount", "", "nodeData", "Lde/blox/graphview/layered/SugiyamaNodeData;", "stack", "", "visited", "assignX", "", "assignY", "balance", "x", "", "", "blockWidth", "calculateGraphSize", "Lde/blox/graphview/util/Size;", "computeBlockWidths", "root", "coordinateAssignment", "copyGraph", "crossing", "northernNodes", "n1", "n2", "cycleRemoval", "denormalize", "dfs", "node", "drawEdges", "canvas", "Landroid/graphics/Canvas;", "linePaint", "Landroid/graphics/Paint;", "exchange", "nodes", "v", "w", "getAdjNodes", "downward", "", "getLayerIndex", "getRootNodes", "horizontalCompactation", "align", "sink", "shift", "leftToRight", "initSugiyamaData", "isLongEdgeDummy", "layerAssignment", "markType1Conflicts", "median", "currentIteration", "nodeOrdering", "placeBlock", "pos", "pred", "reset", "restoreCycle", "run", "shiftX", "shiftY", "setEdgeRenderer", "renderer", "shiftCoordinates", "transpose", "verticalAlignment", "type1Conflicts", "virtualTwinNode", "graphview_release"})
public final class SugiyamaAlgorithm
implements Layout {
    private final Map<Node, SugiyamaNodeData> nodeData;
    private final Map<Edge, SugiyamaEdgeData> edgeData;
    private final Set<Node> stack;
    private final Set<Node> visited;
    private List<ArrayList<Node>> layers;
    private Graph graph;
    private final EdgeRenderer edgeRenderer;
    private int nodeCount;
    private final SugiyamaConfiguration configuration;

    private final String getDummyText() {
        int n = this.nodeCount;
        this.nodeCount = n + 1;
        return "Dummy " + n;
    }

    @Override
    @NotNull
    public Size run(@NotNull Graph graph, float shiftX, float shiftY) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        this.graph = this.copyGraph(graph);
        this.reset();
        this.initSugiyamaData();
        this.cycleRemoval();
        this.layerAssignment();
        this.nodeOrdering();
        this.coordinateAssignment();
        this.shiftCoordinates(shiftX, shiftY);
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Size graphSize = this.calculateGraphSize(graph2);
        this.denormalize();
        this.restoreCycle();
        return graphSize;
    }

    private final Size calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            float f = left;
            float f2 = node.getX();
            boolean bl2 = false;
            float f3 = Math.min(f, f2);
            left = (int)f3;
            f = top;
            f2 = node.getY();
            bl2 = false;
            f3 = Math.min(f, f2);
            top = (int)f3;
            f = right;
            f2 = node.getX() + (float)node.getWidth();
            bl2 = false;
            f3 = Math.max(f, f2);
            right = (int)f3;
            f = bottom;
            f2 = node.getY() + (float)node.getHeight();
            bl2 = false;
            f3 = Math.max(f, f2);
            bottom = (int)f3;
        }
        return new Size(right - left, bottom - top);
    }

    private final void shiftCoordinates(float shiftX, float shiftY) {
        Iterable $this$forEach$iv = this.layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArrayList arrayList = (ArrayList)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = arrayList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node it = (Node)element$iv2;
                boolean bl2 = false;
                Node node = it;
                node.setX(node.getX() + shiftX);
                Node node2 = it;
                node2.setY(node2.getY() + shiftY);
            }
        }
    }

    private final void reset() {
        this.layers.clear();
        this.stack.clear();
        this.visited.clear();
        this.nodeData.clear();
        this.edgeData.clear();
        this.nodeCount = 1;
    }

    private final void initSugiyamaData() {
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            node.setX(0.0f);
            node.setY(0.0f);
            this.nodeData.put(node, new SugiyamaNodeData());
        }
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        $this$forEach$iv = graph2.getEdges();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            this.edgeData.put(edge, new SugiyamaEdgeData());
        }
    }

    private final void cycleRemoval() {
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            this.dfs(node);
        }
    }

    private final void dfs(Node node) {
        if (this.visited.contains(node)) {
            return;
        }
        this.visited.add(node);
        this.stack.add(node);
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getOutEdges(node);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            Node target = edge.getDestination();
            if (this.stack.contains(target)) {
                Graph graph2 = this.graph;
                if (graph2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph2.removeEdge(edge);
                Graph graph3 = this.graph;
                if (graph3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph3.addEdge(target, node);
                ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node)).getReversed().add(target);
                continue;
            }
            this.dfs(target);
        }
        this.stack.remove(node);
    }

    /*
     * WARNING - void declaration
     */
    private final void layerAssignment() {
        int n;
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        if (graph.getNodes().isEmpty()) {
            return;
        }
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Graph copyGraph = this.copyGraph(graph2);
        ArrayList<Node> roots = this.getRootNodes(copyGraph);
        while (true) {
            Node[] nodeArray;
            void $this$toTypedArray$iv;
            Collection collection = roots;
            n = 0;
            if (!(!collection.isEmpty())) break;
            this.layers.add(roots);
            collection = roots;
            Graph graph3 = copyGraph;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new Node[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Node[] nodeArray2 = nodeArray;
            graph3.removeNodes(Arrays.copyOf(nodeArray2, nodeArray2.length));
            roots = this.getRootNodes(copyGraph);
        }
        int $this$toTypedArray$iv = 0;
        n = this.layers.size() - 1;
        while ($this$toTypedArray$iv < n) {
            void i;
            void indexNextLayer = i + true;
            ArrayList<Node> currentLayer = this.layers.get((int)i);
            ArrayList<Node> nextLayer = this.layers.get((int)indexNextLayer);
            for (Node node : currentLayer) {
                Iterable $this$filterTo$iv$iv;
                Graph graph4 = this.graph;
                if (graph4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Iterable $this$filter$iv = graph4.getEdges();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Edge $dstr$source = (Edge)element$iv$iv;
                    boolean bl = false;
                    Node source = $dstr$source.component1();
                    if (!Intrinsics.areEqual((Object)source, (Object)node)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Edge $dstr$_u24__u24$destination = (Edge)element$iv$iv;
                    boolean bl = false;
                    Node destination = $dstr$_u24__u24$destination.component2();
                    int n2 = ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)destination)).getLayer();
                    Node node2 = node;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
                    int n3 = n2 - ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node2)).getLayer();
                    boolean bl2 = false;
                    if (!(Math.abs(n3) > 1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List edges = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Iterator iterator = edges.iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    Node dummy = new Node(this.getDummyText());
                    SugiyamaNodeData dummyNodeData = new SugiyamaNodeData();
                    dummyNodeData.setDummy(true);
                    dummyNodeData.setLayer((int)indexNextLayer);
                    nextLayer.add(dummy);
                    this.nodeData.put(dummy, dummyNodeData);
                    dummy.setSize(edge.getSource().getWidth(), 0);
                    Graph graph5 = this.graph;
                    if (graph5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                    }
                    Edge dummyEdge1 = graph5.addEdge(edge.getSource(), dummy);
                    Graph graph6 = this.graph;
                    if (graph6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                    }
                    Edge dummyEdge2 = graph6.addEdge(dummy, edge.getDestination());
                    this.edgeData.put(dummyEdge1, new SugiyamaEdgeData());
                    this.edgeData.put(dummyEdge2, new SugiyamaEdgeData());
                    Graph graph7 = this.graph;
                    if (graph7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                    }
                    graph7.removeEdge(edge);
                    iterator.remove();
                }
            }
            ++i;
        }
    }

    private final ArrayList<Node> getRootNodes(Graph graph) {
        boolean bl = false;
        ArrayList<Node> roots = new ArrayList<Node>();
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl2 = false;
            int inDegree = 0;
            Iterable $this$forEach$iv2 = graph.getEdges();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Edge $dstr$_u24__u24$destination = (Edge)element$iv2;
                boolean bl3 = false;
                Node destination = $dstr$_u24__u24$destination.component2();
                if (!Intrinsics.areEqual((Object)destination, (Object)node)) continue;
                int n = inDegree;
                inDegree = n + 1;
            }
            if (inDegree != 0) continue;
            roots.add(node);
            ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node)).setLayer(this.layers.size());
        }
        return roots;
    }

    private final Graph copyGraph(Graph graph) {
        Collection $this$toTypedArray$iv;
        Graph copy = new Graph();
        Collection collection = graph.getNodes();
        Graph graph2 = copy;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Node[] nodeArray = thisCollection$iv.toArray(new Node[0]);
        if (nodeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = nodeArray;
        Node[] nodeArray2 = objectArray;
        graph2.addNodes(Arrays.copyOf(nodeArray2, nodeArray2.length));
        $this$toTypedArray$iv = graph.getEdges();
        graph2 = copy;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        Edge[] edgeArray = thisCollection$iv.toArray(new Edge[0]);
        if (edgeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = edgeArray;
        Edge[] edgeArray2 = (Edge[])objectArray;
        graph2.addEdges(Arrays.copyOf(edgeArray2, edgeArray2.length));
        return copy;
    }

    private final void nodeOrdering() {
        ArrayList<ArrayList<Node>> best = new ArrayList<ArrayList<Node>>((Collection)this.layers);
        int n = 0;
        Iterable $this$forEach$iv = (Iterable)new IntRange(n, 23);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.median(best, i);
            this.transpose((List<? extends List<Node>>)best);
            if (this.crossing((List<? extends List<Node>>)best) >= this.crossing(this.layers)) continue;
            this.layers = best;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void median(ArrayList<ArrayList<Node>> layers, int currentIteration) {
        if (currentIteration % 2 == 0) {
            int n = 1;
            int n2 = layers.size();
            while (n < n2) {
                ArrayList<Node> currentLayer;
                void i;
                Intrinsics.checkExpressionValueIsNotNull(layers.get((int)i), (String)"layers[i]");
                Intrinsics.checkExpressionValueIsNotNull(layers.get((int)(i - true)), (String)"layers[i - 1]");
                for (Node node : currentLayer) {
                    int right;
                    void $this$mapTo$iv$iv2;
                    ArrayList<Node> previousLayer;
                    Node source;
                    Edge $dstr$source;
                    Iterable $this$filterTo$iv$iv;
                    Graph graph = this.graph;
                    if (graph == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                    }
                    Iterable $this$filter$iv = graph.getEdges();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        $dstr$source = (Edge)element$iv$iv;
                        boolean bl = false;
                        source = $dstr$source.component1();
                        if (!previousLayer.contains(source)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map22 = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        $dstr$source = (Edge)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        source = $dstr$source.component1();
                        Integer n3 = previousLayer.indexOf(source);
                        collection.add(n3);
                    }
                    List positions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    CollectionsKt.sort((List)positions);
                    int median2 = positions.size() / 2;
                    Collection $i$f$map22 = positions;
                    boolean $this$mapTo$iv$iv2 = false;
                    if (!(!$i$f$map22.isEmpty())) continue;
                    if (positions.size() == 1) {
                        Node node2 = node;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
                        ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node2)).setMedian(-1);
                        continue;
                    }
                    if (positions.size() == 2) {
                        Node node3 = node;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node3, (String)"node");
                        ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node3)).setMedian((((Number)positions.get(0)).intValue() + ((Number)positions.get(1)).intValue()) / 2);
                        continue;
                    }
                    if (positions.size() % 2 == 1) {
                        Node node4 = node;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node4, (String)"node");
                        ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node4)).setMedian(((Number)positions.get(median2)).intValue());
                        continue;
                    }
                    int left = ((Number)positions.get(median2 - 1)).intValue() - ((Number)positions.get(0)).intValue();
                    if (left + (right = ((Number)positions.get(positions.size() - 1)).intValue() - ((Number)positions.get(median2)).intValue()) == 0) continue;
                    Node node5 = node;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node5, (String)"node");
                    ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node5)).setMedian((((Number)positions.get(median2 - 1)).intValue() * right + ((Number)positions.get(median2)).intValue() * left) / (left + right));
                }
                CollectionsKt.sortWith((List)currentLayer, (Comparator)new Comparator<Node>(this){
                    final /* synthetic */ SugiyamaAlgorithm this$0;

                    public final int compare(Node n1, Node n2) {
                        Map map = SugiyamaAlgorithm.access$getNodeData$p(this.this$0);
                        Node node = n1;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"n1");
                        SugiyamaNodeData nodeData1 = (SugiyamaNodeData)MapsKt.getValue((Map)map, (Object)node);
                        Map map2 = SugiyamaAlgorithm.access$getNodeData$p(this.this$0);
                        Node node2 = n2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"n2");
                        SugiyamaNodeData nodeData2 = (SugiyamaNodeData)MapsKt.getValue((Map)map2, (Object)node2);
                        return nodeData1.getMedian() - nodeData2.getMedian();
                    }
                    {
                        this.this$0 = sugiyamaAlgorithm;
                    }
                });
                ++i;
            }
        } else {
            int i = 1;
            int n = layers.size();
            while (i < n) {
                ArrayList<Node> currentLayer;
                void l;
                Intrinsics.checkExpressionValueIsNotNull(layers.get((int)l), (String)"layers[l]");
                Intrinsics.checkExpressionValueIsNotNull(layers.get((int)(l - true)), (String)"layers[l - 1]");
                int node = currentLayer.size() - 1;
                int n4 = 1;
                while (node >= n4) {
                    Object object;
                    void $this$mapTo$iv$iv;
                    ArrayList<Node> previousLayer;
                    Node source;
                    Edge $dstr$source;
                    Iterable $this$filterTo$iv$iv;
                    void i2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)currentLayer.get((int)i2), (String)"currentLayer[i]");
                    Graph graph = this.graph;
                    if (graph == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                    }
                    Iterable $this$filter$iv = graph.getEdges();
                    boolean $i$f$filter = false;
                    Iterable destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        $dstr$source = (Edge)element$iv$iv;
                        boolean bl = false;
                        source = $dstr$source.component1();
                        if (!previousLayer.contains(source)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv2;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        $dstr$source = (Edge)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl = false;
                        source = $dstr$source.component1();
                        Integer n5 = previousLayer.indexOf(source);
                        object.add(n5);
                    }
                    List positions = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                    CollectionsKt.sort((List)positions);
                    Collection collection = positions;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        Node node6;
                        if (positions.size() == 1) {
                            ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node6)).setMedian(((Number)positions.get(0)).intValue());
                        } else {
                            double d = (double)positions.size() / 2.0;
                            List list = positions;
                            object = (SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node6);
                            boolean bl2 = false;
                            double d2 = Math.ceil(d);
                            d = (double)positions.size() / 2.0;
                            List list2 = positions;
                            int n6 = ((Number)list.get((int)d2)).intValue();
                            bl2 = false;
                            double d3 = Math.ceil(d);
                            ((SugiyamaNodeData)object).setMedian((n6 + ((Number)list2.get((int)d3 - 1)).intValue()) / 2);
                        }
                    }
                    --i2;
                }
                CollectionsKt.sortWith((List)currentLayer, (Comparator)new Comparator<Node>(this){
                    final /* synthetic */ SugiyamaAlgorithm this$0;

                    public final int compare(Node n1, Node n2) {
                        Map map = SugiyamaAlgorithm.access$getNodeData$p(this.this$0);
                        Node node = n1;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"n1");
                        SugiyamaNodeData nodeData1 = (SugiyamaNodeData)MapsKt.getValue((Map)map, (Object)node);
                        Map map2 = SugiyamaAlgorithm.access$getNodeData$p(this.this$0);
                        Node node2 = n2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"n2");
                        SugiyamaNodeData nodeData2 = (SugiyamaNodeData)MapsKt.getValue((Map)map2, (Object)node2);
                        return nodeData1.getMedian() - nodeData2.getMedian();
                    }
                    {
                        this.this$0 = sugiyamaAlgorithm;
                    }
                });
                ++l;
            }
        }
    }

    private final void transpose(List<? extends List<Node>> layers) {
        boolean improved = true;
        while (improved) {
            improved = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(layers.size() - 1));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int l = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                List<Node> northernNodes = layers.get(l);
                List<Node> southernNodes = layers.get(l + 1);
                Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)(southernNodes.size() - 1));
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    Node w;
                    int element$iv2;
                    int i = element$iv2 = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    Node v = southernNodes.get(i);
                    if (this.crossing(northernNodes, v, w = southernNodes.get(i + 1)) <= this.crossing(northernNodes, w, v)) continue;
                    improved = true;
                    this.exchange(southernNodes, v, w);
                }
            }
        }
    }

    private final void exchange(List<Node> nodes, Node v, Node w) {
        Collections.swap(nodes, nodes.indexOf(v), nodes.indexOf(w));
    }

    /*
     * WARNING - void declaration
     */
    private final int crossing(List<Node> northernNodes, Node n1, Node n2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Node node;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Edge $dstr$_u24__u24$destination;
        Iterable $this$filterTo$iv$iv2;
        int crossing = 0;
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$filter$iv = graph.getEdges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            $dstr$_u24__u24$destination = (Edge)element$iv$iv;
            boolean bl = false;
            Node destination = $dstr$_u24__u24$destination.component2();
            if (!Intrinsics.areEqual((Object)destination, (Object)n1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            $dstr$_u24__u24$destination = (Edge)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            node = it.getSource();
            collection.add(node);
        }
        List parentNodesN1 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$filter$iv2 = graph2.getEdges();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Edge $dstr$_u24__u24$destination2 = (Edge)element$iv$iv;
            boolean bl = false;
            Node destination = $dstr$_u24__u24$destination2.component2();
            if (!Intrinsics.areEqual((Object)destination, (Object)n2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Edge $dstr$_u24__u24$destination2 = (Edge)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            node = it.getSource();
            collection.add(node);
        }
        List parentNodesN2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterable $this$forEach$iv = parentNodesN2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv3;
            Node pn2 = (Node)element$iv;
            boolean bl = false;
            int indexOfPn2 = northernNodes.indexOf(pn2);
            Iterable $this$filter$iv3 = parentNodesN1;
            boolean $i$f$filter3 = false;
            Iterable destination = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Node it = (Node)element$iv$iv;
                boolean bl2 = false;
                if (!(indexOfPn2 < northernNodes.indexOf(it))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            int n = ((List)destination$iv$iv3).size();
            boolean bl3 = false;
            int n3 = 0;
            n3 = 0;
            int n4 = n;
            while (n3 < n4) {
                int it = n3++;
                boolean bl4 = false;
                int n5 = crossing;
                crossing = n5 + 1;
            }
        }
        return crossing;
    }

    /*
     * WARNING - void declaration
     */
    private final int crossing(List<? extends List<Node>> layers) {
        int crossing = 0;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(layers.size() - 1));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int l = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            List<Node> southernNodes = layers.get(l);
            List<Node> northernNodes = layers.get(l + 1);
            int n = 0;
            int n2 = southernNodes.size() - 2;
            while (n < n2) {
                void i;
                Node v = southernNodes.get((int)i);
                Node w = southernNodes.get((int)(i + true));
                crossing += this.crossing(northernNodes, v, w);
                ++i;
            }
        }
        return crossing;
    }

    private final void coordinateAssignment() {
        this.assignX();
        this.assignY();
    }

    /*
     * WARNING - void declaration
     */
    private final void assignX() {
        boolean $i$f$forEach;
        int element$iv;
        ArrayList root = new ArrayList(4);
        ArrayList align = new ArrayList(4);
        ArrayList sink = new ArrayList(4);
        ArrayList x = new ArrayList(4);
        ArrayList shift = new ArrayList(4);
        ArrayList blockWidth = new ArrayList(4);
        int n = 0;
        Iterable $this$forEach$iv22 = (Iterable)new IntRange(n, 3);
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv22.iterator();
        while (iterator.hasNext()) {
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            root.add(new HashMap());
            align.add(new HashMap());
            sink.add(new HashMap());
            shift.add(new HashMap());
            x.add(new HashMap());
            blockWidth.add(new HashMap());
            Graph graph = this.graph;
            if (graph == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
            }
            Iterable $this$forEach$iv = graph.getNodes();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Node n2 = (Node)element$iv2;
                boolean bl2 = false;
                Object e = root.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"root[i]");
                ((Map)e).put(n2, n2);
                Object e2 = align.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"align[i]");
                ((Map)e2).put(n2, n2);
                Object e3 = sink.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e3, (String)"sink[i]");
                ((Map)e3).put(n2, n2);
                Object e4 = shift.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e4, (String)"shift[i]");
                ((Map)e4).put(n2, Float.valueOf(Float.MAX_VALUE));
                Object e5 = x.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e5, (String)"x[i]");
                ((Map)e5).put(n2, Float.valueOf(Float.MIN_VALUE));
                Object e6 = blockWidth.get(i);
                Intrinsics.checkExpressionValueIsNotNull(e6, (String)"blockWidth[i]");
                ((Map)e6).put(n2, Float.valueOf(0.0f));
            }
        }
        int $this$forEach$iv22 = 0;
        Iterable $this$forEach$iv = (Iterable)new IntRange($this$forEach$iv22, 1);
        $i$f$forEach2 = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int downward = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            List<List<Boolean>> type1Conflicts = this.markType1Conflicts(downward == 0);
            $i$f$forEach = false;
            boolean bl3 = true;
            while ($i$f$forEach <= bl3) {
                void leftToRight;
                int k = 2 * downward + leftToRight;
                Object e = root.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"root[k]");
                Map map = (Map)e;
                Object e7 = align.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e7, (String)"align[k]");
                this.verticalAlignment(map, (Map)e7, type1Conflicts, downward == 0, leftToRight == false);
                Object e8 = root.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e8, (String)"root[k]");
                Map map2 = (Map)e8;
                Object e9 = blockWidth.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e9, (String)"blockWidth[k]");
                this.computeBlockWidths(map2, (Map)e9);
                Object e10 = align.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e10, (String)"align[k]");
                Map map3 = (Map)e10;
                Object e11 = root.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e11, (String)"root[k]");
                Map map4 = (Map)e11;
                Object e12 = sink.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e12, (String)"sink[k]");
                Map map5 = (Map)e12;
                Object e13 = shift.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e13, (String)"shift[k]");
                Map map6 = (Map)e13;
                Object e14 = blockWidth.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e14, (String)"blockWidth[k]");
                Map map7 = (Map)e14;
                Object e15 = x.get(k);
                Intrinsics.checkExpressionValueIsNotNull(e15, (String)"x[k]");
                this.horizontalCompactation(map3, map4, map5, map6, map7, (Map)e15, leftToRight == false, downward == 0);
                ++leftToRight;
            }
        }
        this.balance(x, blockWidth);
    }

    /*
     * WARNING - void declaration
     */
    private final void balance(List<? extends Map<Node, Float>> x, List<? extends Map<Node, Float>> blockWidth) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        float minValue;
        void $this$flatMapTo$iv$iv;
        Object element$iv4;
        Iterator $this$filterTo$iv$iv;
        HashMap coordinates = new HashMap();
        float minWidth = Float.MAX_VALUE;
        int smallestWidthLayout = 0;
        float[] min = new float[4];
        float[] max = new float[4];
        int n = 0;
        Iterable $this$forEach$iv22 = (Iterable)new IntRange(n, 3);
        int $i$f$forEach2 = 0;
        Object object = $this$forEach$iv22.iterator();
        while (object.hasNext()) {
            int element$iv2;
            int i = element$iv2 = ((IntIterator)object).nextInt();
            boolean bl = false;
            min[i] = Integer.MAX_VALUE;
            max[i] = 0.0f;
            Graph graph = this.graph;
            if (graph == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
            }
            Iterable $this$forEach$iv3 = graph.getNodes();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Node v = (Node)element$iv3;
                boolean bl2 = false;
                float bw = 0.5f * ((Number)MapsKt.getValue(blockWidth.get(i), (Object)v)).floatValue();
                float xp = ((Number)MapsKt.getValue(x.get(i), (Object)v)).floatValue() - bw;
                if (xp < min[i]) {
                    min[i] = xp;
                }
                if (!((xp = ((Number)MapsKt.getValue(x.get(i), (Object)v)).floatValue() + bw) > max[i])) continue;
                max[i] = xp;
            }
            float width = max[i] - min[i];
            if (!(width < minWidth)) continue;
            minWidth = width;
            smallestWidthLayout = i;
        }
        int $this$forEach$iv22 = 0;
        Iterable $this$filter$iv = (Iterable)new IntRange($this$forEach$iv22, 3);
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            int it = ((Number)element$iv$iv).intValue();
            boolean bl3 = false;
            if (!(it != smallestWidthLayout)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv4 = (List)destination$iv$iv;
        $i$f$forEach2 = 0;
        for (Object element$iv4 : $this$forEach$iv4) {
            float diff;
            int it = ((Number)element$iv4).intValue();
            boolean bl4 = false;
            if (it == 0 || it == 1) {
                diff = min[it] - min[smallestWidthLayout];
                for (Node n2 : x.get(it).keySet()) {
                    if (diff > 0.0f) {
                        x.get(it).put(n2, Float.valueOf(((Number)MapsKt.getValue(x.get(it), (Object)n2)).floatValue() - diff));
                        continue;
                    }
                    x.get(it).put(n2, Float.valueOf(((Number)MapsKt.getValue(x.get(it), (Object)n2)).floatValue() + diff));
                }
                continue;
            }
            diff = max[it] - max[smallestWidthLayout];
            Iterable $this$forEach$iv5 = x.get(it).keySet();
            boolean $i$f$forEach4 = false;
            for (Object element$iv5 : $this$forEach$iv5) {
                Node n3 = (Node)element$iv5;
                boolean bl5 = false;
                if (diff > 0.0f) {
                    x.get(it).put(n3, Float.valueOf(((Number)MapsKt.getValue(x.get(it), (Object)n3)).floatValue() - diff));
                    continue;
                }
                x.get(it).put(n3, Float.valueOf(((Number)MapsKt.getValue(x.get(it), (Object)n3)).floatValue() + diff));
            }
        }
        $i$f$forEach2 = 0;
        Iterable $this$flatMap$iv2 = (Iterable)new IntRange($i$f$forEach2, 3);
        boolean $i$f$flatMap = false;
        element$iv4 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator diff = $this$flatMapTo$iv$iv.iterator();
        while (diff.hasNext()) {
            int element$iv$iv;
            int it = element$iv$iv = ((IntIterator)diff).nextInt();
            boolean bl6 = false;
            Iterable list$iv$iv = x.get(it).values();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        Float f = CollectionsKt.min((Iterable)list);
        float f2 = minValue = f != null ? f.floatValue() : Float.MAX_VALUE;
        if (minValue != 0.0f) {
            int $this$flatMap$iv2 = 0;
            $this$forEach$iv = (Iterable)new IntRange($this$flatMap$iv2, 3);
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv6;
                int i = element$iv6 = ((IntIterator)iterator).nextInt();
                boolean bl7 = false;
                Iterable $this$forEach$iv6 = x.get(i).keySet();
                boolean $i$f$forEach5 = false;
                for (Object element$iv5 : $this$forEach$iv6) {
                    Node n4 = (Node)element$iv5;
                    boolean bl8 = false;
                    x.get(i).put(n4, Float.valueOf(((Number)MapsKt.getValue(x.get(i), (Object)n4)).floatValue() - minValue));
                }
            }
        }
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        $this$forEach$iv = graph.getNodes();
        $i$f$forEach = false;
        for (Object element$iv7 : $this$forEach$iv) {
            Node n5 = (Node)element$iv7;
            boolean bl9 = false;
            float[] values = new float[4];
            int $i$f$forEach5 = 0;
            Iterable $this$forEach$iv7 = (Iterable)new IntRange($i$f$forEach5, 3);
            boolean $i$f$forEach6 = false;
            Iterator iterator = $this$forEach$iv7.iterator();
            while (iterator.hasNext()) {
                int element$iv8;
                int i = element$iv8 = ((IntIterator)iterator).nextInt();
                boolean bl10 = false;
                values[i] = ((Number)MapsKt.getValue(x.get(i), (Object)n5)).floatValue();
            }
            Arrays.sort(values);
            float average = (values[1] + values[2]) / (float)2;
            ((Map)coordinates).put(n5, Float.valueOf(average));
        }
        Collection collection = coordinates.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"coordinates.values");
        Float f3 = CollectionsKt.min((Iterable)collection);
        minValue = f3 != null ? f3.floatValue() : (float)Integer.MAX_VALUE;
        if (minValue != 0.0f) {
            Set set = coordinates.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"coordinates.keys");
            $this$forEach$iv = set;
            $i$f$forEach = false;
            for (Object element$iv9 : $this$forEach$iv) {
                Node n6 = (Node)element$iv9;
                boolean bl11 = false;
                Map map = coordinates;
                Node node = n6;
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"n");
                map.put(node, Float.valueOf(((Number)MapsKt.getValue((Map)coordinates, (Object)n6)).floatValue() - minValue));
            }
        }
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        $this$forEach$iv = graph2.getNodes();
        $i$f$forEach = false;
        for (Object element$iv10 : $this$forEach$iv) {
            Node v = (Node)element$iv10;
            boolean bl12 = false;
            v.setX(((Number)MapsKt.getValue((Map)coordinates, (Object)v)).floatValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Boolean>> markType1Conflicts(boolean downward) {
        ArrayList type1Conflicts = new ArrayList();
        int n = 0;
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        int n2 = ((Collection)graph.getNodes()).size();
        while (n < n2) {
            void i;
            type1Conflicts.add(new ArrayList());
            int n3 = 0;
            Graph graph2 = this.graph;
            if (graph2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
            }
            int n4 = ((Collection)graph2.getEdges()).size();
            while (n3 < n4) {
                void l;
                ((ArrayList)type1Conflicts.get((int)i)).add(false);
                ++l;
            }
            ++i;
        }
        if (this.layers.size() >= 4) {
            int upper = 0;
            int lower = 0;
            Ref.IntRef k1 = new Ref.IntRef();
            if (downward) {
                lower = 1;
                upper = this.layers.size() - 2;
            } else {
                lower = this.layers.size() - 1;
                upper = 2;
            }
            int i = lower;
            while (downward && i <= upper || !downward && i >= upper) {
                int k0 = 0;
                int firstIndex = 0;
                ArrayList<Node> currentLevel = this.layers.get(i);
                ArrayList<Node> nextLevel = downward ? this.layers.get(i + 1) : this.layers.get(i - 1);
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)nextLevel.size());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int l1 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    Node node = nextLevel.get(l1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"nextLevel[l1]");
                    Node virtualTwin = this.virtualTwinNode(node, downward);
                    if (l1 != nextLevel.size() - 1 && virtualTwin == null) continue;
                    k1.element = currentLevel.size() - 1;
                    if (virtualTwin != null) {
                        k1.element = this.pos(virtualTwin);
                    }
                    while (firstIndex <= l1) {
                        Node node2 = nextLevel.get(l1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"nextLevel[l1]");
                        List<Node> upperNeighbours = this.getAdjNodes(node2, downward);
                        for (Node currentNeighbour : upperNeighbours) {
                            int currentNeighbourIndex = this.pos(currentNeighbour);
                            if (currentNeighbourIndex >= k0 && currentNeighbourIndex <= k1.element) continue;
                            ((ArrayList)type1Conflicts.get(l1)).set(currentNeighbourIndex, true);
                        }
                        int n5 = firstIndex;
                        firstIndex = n5 + 1;
                    }
                    k0 = k1.element;
                }
                i = downward ? i + 1 : i - 1;
            }
        }
        return type1Conflicts;
    }

    private final void verticalAlignment(Map<Node, Node> root, Map<Node, Node> align, List<? extends List<Boolean>> type1Conflicts, boolean downward, boolean leftToRight) {
        int i;
        int n = i = downward ? 0 : this.layers.size() - 1;
        while (downward && i <= this.layers.size() - 1 || !downward && i >= 0) {
            int k;
            ArrayList<Node> currentLevel = this.layers.get(i);
            int r = leftToRight ? -1 : Integer.MAX_VALUE;
            int n2 = k = leftToRight ? 0 : currentLevel.size() - 1;
            while (leftToRight && k <= currentLevel.size() - 1 || !leftToRight && k >= 0) {
                Node v;
                Intrinsics.checkExpressionValueIsNotNull((Object)currentLevel.get(k), (String)"currentLevel[k]");
                List<Node> adjNodes = this.getAdjNodes(v, downward);
                Collection collection = adjNodes;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    double d = (double)(adjNodes.size() + 1) / 2.0;
                    boolean bl2 = false;
                    int median2 = (int)Math.floor(d);
                    int medianCount = adjNodes.size() % 2 == 1 ? 1 : 2;
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)medianCount);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int count = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl3 = false;
                        Node m = adjNodes.get(median2 + count - 1);
                        int posM = this.pos(m);
                        if (!Intrinsics.areEqual((Object)align.get(v), (Object)v) || type1Conflicts.get(this.pos(v)).get(posM).booleanValue() || (!leftToRight || r >= posM) && (leftToRight || r <= posM)) continue;
                        align.put(m, v);
                        root.put(v, (Node)MapsKt.getValue(root, (Object)m));
                        align.put(v, (Node)MapsKt.getValue(root, (Object)v));
                        r = posM;
                    }
                }
                k = leftToRight ? k + 1 : k - 1;
            }
            i = downward ? i + 1 : i - 1;
        }
    }

    private final void computeBlockWidths(Map<Node, Node> root, Map<Node, Float> blockWidth) {
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node v = (Node)element$iv;
            boolean bl = false;
            Node r = (Node)MapsKt.getValue(root, (Object)v);
            float f = ((Number)MapsKt.getValue(blockWidth, (Object)r)).floatValue();
            float f2 = v.getWidth();
            Node node = r;
            Map<Node, Float> map = blockWidth;
            boolean bl2 = false;
            float f3 = Math.max(f, f2);
            map.put(node, Float.valueOf(f3));
        }
    }

    private final void horizontalCompactation(Map<Node, Node> align, Map<Node, Node> root, Map<Node, Node> sink, Map<Node, Float> shift, Map<Node, Float> blockWidth, Map<Node, Float> x, boolean leftToRight, boolean downward) {
        Node v;
        int i;
        int n = i = downward ? 0 : this.layers.size() - 1;
        while (downward && i <= this.layers.size() - 1 || !downward && i >= 0) {
            int j;
            ArrayList<Node> currentLevel = this.layers.get(i);
            int n2 = j = leftToRight ? 0 : currentLevel.size() - 1;
            while (leftToRight && j <= currentLevel.size() - 1 || !leftToRight && j >= 0) {
                Intrinsics.checkExpressionValueIsNotNull((Object)currentLevel.get(j), (String)"currentLevel[j]");
                if (Intrinsics.areEqual((Object)root.get(v), (Object)v)) {
                    this.placeBlock(v, sink, shift, x, align, blockWidth, root, leftToRight);
                }
                j = leftToRight ? j + 1 : j - 1;
            }
            i = downward ? i + 1 : i - 1;
        }
        float d = 0.0f;
        int n3 = i = downward ? 0 : this.layers.size() - 1;
        while (downward && i <= this.layers.size() - 1 || !downward && i >= 0) {
            ArrayList<Node> currentLevel = this.layers.get(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)currentLevel.get(leftToRight ? 0 : currentLevel.size() - 1), (String)"currentLevel[if (leftToR\u2026se currentLevel.size - 1]");
            Map<Node, Node> map = sink;
            Node node = root.get(v);
            Node node2 = v;
            boolean bl = false;
            Object v2 = map.get(node);
            if (Intrinsics.areEqual((Object)node2, (Object)((Node)v2))) {
                float oldShift = ((Number)MapsKt.getValue(shift, (Object)v)).floatValue();
                if (oldShift < Float.MAX_VALUE) {
                    shift.put(v, Float.valueOf(oldShift + d));
                    d += oldShift;
                } else {
                    shift.put(v, Float.valueOf(0.0f));
                }
            }
            i = downward ? i + 1 : i - 1;
        }
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node v3 = (Node)element$iv;
            boolean bl = false;
            x.put(v3, (Float)MapsKt.getValue(x, (Object)MapsKt.getValue(root, (Object)v3)));
            float shiftVal = ((Number)MapsKt.getValue(shift, (Object)MapsKt.getValue(sink, (Object)MapsKt.getValue(root, (Object)v3)))).floatValue();
            if (!(shiftVal < Float.MAX_VALUE)) continue;
            x.put(v3, Float.valueOf(((Number)MapsKt.getValue(x, (Object)v3)).floatValue() + shiftVal));
        }
    }

    private final void placeBlock(Node v, Map<Node, Node> sink, Map<Node, Float> shift, Map<Node, Float> x, Map<Node, Node> align, Map<Node, Float> blockWidth, Map<Node, Node> root, boolean leftToRight) {
        if (Intrinsics.areEqual((Float)x.get(v), (float)Float.MIN_VALUE)) {
            x.put(v, Float.valueOf(0.0f));
            Node w = v;
            do {
                float f;
                boolean bl;
                Map<Node, Float> map;
                Object object;
                float f2;
                float f3;
                Node pred;
                if ((!leftToRight || this.pos(w) <= 0) && (leftToRight || this.pos(w) >= this.layers.get(this.getLayerIndex(w)).size() - 1)) continue;
                Node node = pred = this.pred(w, leftToRight);
                if (node == null) {
                    Intrinsics.throwNpe();
                }
                Node u = (Node)MapsKt.getValue(root, (Object)node);
                this.placeBlock(u, sink, shift, x, align, blockWidth, root, leftToRight);
                if (Intrinsics.areEqual((Object)sink.get(v), (Object)v)) {
                    sink.put(v, (Node)MapsKt.getValue(sink, (Object)u));
                }
                if (Intrinsics.areEqual((Object)sink.get(v), (Object)sink.get(u)) ^ true) {
                    if (leftToRight) {
                        f3 = ((Number)MapsKt.getValue(shift, (Object)MapsKt.getValue(sink, (Object)u))).floatValue();
                        f2 = ((Number)MapsKt.getValue(x, (Object)v)).floatValue() - ((Number)MapsKt.getValue(x, (Object)u)).floatValue() - (float)this.configuration.getNodeSeparation() - 0.5f * (((Number)MapsKt.getValue(blockWidth, (Object)u)).floatValue() + ((Number)MapsKt.getValue(blockWidth, (Object)v)).floatValue());
                        object = MapsKt.getValue(sink, (Object)u);
                        map = shift;
                        bl = false;
                        f = Math.min(f3, f2);
                        map.put((Node)object, Float.valueOf(f));
                        continue;
                    }
                    f3 = ((Number)MapsKt.getValue(shift, (Object)MapsKt.getValue(sink, (Object)u))).floatValue();
                    f2 = ((Number)MapsKt.getValue(x, (Object)v)).floatValue() - ((Number)MapsKt.getValue(x, (Object)u)).floatValue() + (float)this.configuration.getNodeSeparation() + 0.5f * (((Number)MapsKt.getValue(blockWidth, (Object)u)).floatValue() + ((Number)MapsKt.getValue(blockWidth, (Object)v)).floatValue());
                    object = MapsKt.getValue(sink, (Object)u);
                    map = shift;
                    bl = false;
                    f = Math.max(f3, f2);
                    map.put((Node)object, Float.valueOf(f));
                    continue;
                }
                if (leftToRight) {
                    f3 = ((Number)MapsKt.getValue(x, (Object)v)).floatValue();
                    f2 = ((Number)MapsKt.getValue(x, (Object)u)).floatValue() + (float)this.configuration.getNodeSeparation() + 0.5f * (((Number)MapsKt.getValue(blockWidth, (Object)u)).floatValue() + ((Number)MapsKt.getValue(blockWidth, (Object)v)).floatValue());
                    object = v;
                    map = x;
                    bl = false;
                    f = Math.max(f3, f2);
                    map.put((Node)object, Float.valueOf(f));
                    continue;
                }
                f3 = ((Number)MapsKt.getValue(x, (Object)v)).floatValue();
                f2 = ((Number)MapsKt.getValue(x, (Object)u)).floatValue() - (float)this.configuration.getNodeSeparation() - 0.5f * (((Number)MapsKt.getValue(blockWidth, (Object)u)).floatValue() + ((Number)MapsKt.getValue(blockWidth, (Object)v)).floatValue());
                object = v;
                map = x;
                bl = false;
                f = Math.min(f3, f2);
                map.put((Node)object, Float.valueOf(f));
            } while (Intrinsics.areEqual((Object)(w = (Node)MapsKt.getValue(align, (Object)w)), (Object)v) ^ true);
        }
    }

    private final Node pred(Node v, boolean leftToRight) {
        int pos = this.pos(v);
        int rank = this.getLayerIndex(v);
        ArrayList<Node> level = this.layers.get(rank);
        return leftToRight && pos != 0 || !leftToRight && pos != level.size() - 1 ? level.get(leftToRight ? pos - 1 : pos + 1) : null;
    }

    private final Node virtualTwinNode(Node node, boolean downward) {
        if (!this.isLongEdgeDummy(node)) {
            return null;
        }
        List<Node> adjNodes = this.getAdjNodes(node, downward);
        return adjNodes.isEmpty() ? null : adjNodes.get(0);
    }

    private final List<Node> getAdjNodes(Node node, boolean downward) {
        List<Node> list;
        if (downward) {
            Graph graph = this.graph;
            if (graph == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
            }
            list = graph.predecessorsOf(node);
        } else {
            Graph graph = this.graph;
            if (graph == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
            }
            list = graph.successorsOf(node);
        }
        return list;
    }

    private final int pos(Node node) {
        Iterable $this$forEach$iv = this.layers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArrayList l = (ArrayList)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = l;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node n = (Node)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)node, (Object)n)) continue;
                return l.indexOf(node);
            }
        }
        return -1;
    }

    private final int getLayerIndex(Node node) {
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)this.layers);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int l = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.layers.get(l);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node n = (Node)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)node, (Object)n)) continue;
                return l;
            }
        }
        return -1;
    }

    private final boolean isLongEdgeDummy(Node v) {
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        List<Node> successors = graph.successorsOf(v);
        return ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)v)).isDummy() && successors.size() == 1 && ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)successors.get(0))).isDummy();
    }

    /*
     * WARNING - void declaration
     */
    private final void assignY() {
        int element$iv;
        int k = this.layers.size();
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        float[] height = new float[graph.getNodes().size()];
        ArraysKt.fill$default((float[])height, (float)0.0f, (int)0, (int)0, (int)6, null);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)k);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            ArrayList<Node> level = this.layers.get(i);
            int n = 0;
            int n2 = ((Collection)level).size();
            while (n < n2) {
                Node node;
                float h;
                void j;
                Intrinsics.checkExpressionValueIsNotNull((Object)level.get((int)j), (String)"level[j]");
                float f = h = ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)node)).isDummy() ? 0.0f : (float)node.getHeight();
                if (h > height[i]) {
                    height[i] = h;
                }
                ++j;
            }
        }
        float yPos = 0.0f;
        int i = 0;
        while (true) {
            ArrayList<Node> level = this.layers.get(i);
            element$iv = 0;
            int n = ((Collection)level).size();
            while (element$iv < n) {
                void j;
                level.get((int)j).setY(yPos);
                ++j;
            }
            if (i == k - 1) break;
            yPos += (float)((double)this.configuration.getLevelSeparation() + 0.5 * (double)(height[i] + height[i + 1]));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void denormalize() {
        int n = 1;
        int n2 = this.layers.size() - 1;
        while (n < n2) {
            Iterator<Node> iterator;
            void i;
            Intrinsics.checkExpressionValueIsNotNull(this.layers.get((int)i).iterator(), (String)"layers[i].iterator()");
            while (iterator.hasNext()) {
                List<Float> bendPoints;
                Node current;
                Intrinsics.checkExpressionValueIsNotNull((Object)iterator.next(), (String)"iterator.next()");
                if (!((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)current)).isDummy()) continue;
                Graph graph = this.graph;
                if (graph == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Node predecessor = graph.predecessorsOf(current).get(0);
                Graph graph2 = this.graph;
                if (graph2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Node successor = graph2.successorsOf(current).get(0);
                Graph graph3 = this.graph;
                if (graph3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Edge edge = graph3.getEdgeBetween(predecessor, current);
                if (edge == null) {
                    Intrinsics.throwNpe();
                }
                if ((bendPoints = ((SugiyamaEdgeData)MapsKt.getValue(this.edgeData, (Object)edge)).getBendPoints()).isEmpty() || !bendPoints.contains(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f))) {
                    bendPoints.add(Float.valueOf(predecessor.getX() + (float)predecessor.getWidth() / 2.0f));
                    bendPoints.add(Float.valueOf(predecessor.getY() + (float)predecessor.getHeight() / 2.0f));
                    bendPoints.add(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f));
                    bendPoints.add(Float.valueOf(current.getY()));
                }
                if (!((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)predecessor)).isDummy()) {
                    bendPoints.add(Float.valueOf(current.getX() + (float)predecessor.getWidth() / 2.0f));
                } else {
                    bendPoints.add(Float.valueOf(current.getX()));
                }
                bendPoints.add(Float.valueOf(current.getY()));
                if (((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)successor)).isDummy()) {
                    bendPoints.add(Float.valueOf(successor.getX() + (float)predecessor.getWidth() / 2.0f));
                } else {
                    bendPoints.add(Float.valueOf(successor.getX() + (float)successor.getWidth() / 2.0f));
                }
                bendPoints.add(Float.valueOf(successor.getY() + (float)successor.getHeight() / 2.0f));
                Graph graph4 = this.graph;
                if (graph4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph4.removeEdge(predecessor, current);
                Graph graph5 = this.graph;
                if (graph5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph5.removeEdge(current, successor);
                Graph graph6 = this.graph;
                if (graph6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Edge edge2 = graph6.addEdge(predecessor, successor);
                SugiyamaEdgeData sugiyamaEdgeData = new SugiyamaEdgeData();
                sugiyamaEdgeData.setBendPoints(bendPoints);
                this.edgeData.put(edge2, sugiyamaEdgeData);
                iterator.remove();
                Graph graph7 = this.graph;
                if (graph7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph7.removeNode(current);
            }
            ++i;
        }
    }

    private final void restoreCycle() {
        Graph graph = this.graph;
        if (graph == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node n = (Node)element$iv;
            boolean bl = false;
            if (!((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)n)).isReversed()) continue;
            Iterable $this$forEach$iv2 = ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)n)).getReversed();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node target = (Node)element$iv2;
                boolean bl2 = false;
                Graph graph2 = this.graph;
                if (graph2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Edge edge = graph2.getEdgeBetween(target, n);
                if (edge == null) {
                    Intrinsics.throwNpe();
                }
                List<Float> bendPoints = ((SugiyamaEdgeData)MapsKt.getValue(this.edgeData, (Object)edge)).getBendPoints();
                Graph graph3 = this.graph;
                if (graph3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                graph3.removeEdge(target, n);
                Graph graph4 = this.graph;
                if (graph4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
                }
                Edge edge2 = graph4.addEdge(n, target);
                SugiyamaEdgeData edgeData = new SugiyamaEdgeData();
                edgeData.setBendPoints(bendPoints);
                this.edgeData.put(edge2, edgeData);
            }
        }
    }

    @Override
    public void drawEdges(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint linePaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)linePaint, (String)"linePaint");
        Graph graph2 = this.graph;
        if (graph2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graph");
        }
        this.edgeRenderer.render(canvas, graph2, linePaint);
    }

    @Override
    public void setEdgeRenderer(@NotNull EdgeRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        throw (Throwable)new UnsupportedOperationException("SugiyamaAlgorithm currently not support custom edge renderer!");
    }

    @JvmOverloads
    public SugiyamaAlgorithm(@NotNull SugiyamaConfiguration configuration) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.nodeData = new HashMap();
        this.edgeData = new HashMap();
        this.stack = new HashSet();
        this.visited = new HashSet();
        SugiyamaAlgorithm sugiyamaAlgorithm = this;
        boolean bl = false;
        sugiyamaAlgorithm.layers = list = (List)new ArrayList();
        this.edgeRenderer = new SugiyamaEdgeRenderer(this.nodeData, this.edgeData);
        this.nodeCount = 1;
    }

    public /* synthetic */ SugiyamaAlgorithm(SugiyamaConfiguration sugiyamaConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sugiyamaConfiguration = new SugiyamaConfiguration.Builder().build();
        }
        this(sugiyamaConfiguration);
    }

    @JvmOverloads
    public SugiyamaAlgorithm() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Map access$getNodeData$p(SugiyamaAlgorithm $this) {
        return $this.nodeData;
    }
}

