/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.energy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Layout;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.ArrowEdgeRenderer;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.util.Size;
import de.blox.graphview.util.VectorF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u0000 D2\u00020\u0001:\u0002DEB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\u0016\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0003H\u0002J\b\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010-\u001a\u0004\u0018\u00010\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u00172\u0006\u0010/\u001a\u00020\tH\u0002J.\u00100\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\"2\u0006\u0010/\u001a\u00020\t2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\t0!H\u0002J\u0010\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J\u0010\u00105\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002J\u0010\u00106\u001a\u00020\n2\u0006\u0010/\u001a\u00020\tH\u0002J\u0010\u00107\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u00108\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\u0016\u00109\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010;\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J \u0010<\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0016J\u0018\u0010?\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\t2\u0006\u0010@\u001a\u00020\nH\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\fH\u0016J \u0010C\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lde/blox/graphview/energy/FruchtermanReingoldAlgorithm;", "Lde/blox/graphview/Layout;", "iterations", "", "(I)V", "attraction_k", "", "disps", "", "Lde/blox/graphview/Node;", "Lde/blox/graphview/util/VectorF;", "edgeRenderer", "Lde/blox/graphview/edgerenderer/EdgeRenderer;", "height", "k", "rand", "Ljava/util/Random;", "repulsion_k", "t", "width", "calculateAttraction", "", "edges", "", "Lde/blox/graphview/Edge;", "calculateGraphSize", "Lde/blox/graphview/util/Size;", "graph", "Lde/blox/graphview/Graph;", "calculateRepulsion", "nodes", "combineSingleNodeCluster", "nodeClusters", "", "Lde/blox/graphview/energy/FruchtermanReingoldAlgorithm$NodeCluster;", "cool", "currentIteration", "done", "", "drawEdges", "canvas", "Landroid/graphics/Canvas;", "linePaint", "Landroid/graphics/Paint;", "findBiggestSize", "findClusterOf", "clusters", "node", "followEdges", "cluster", "nodesVisited", "forceAttraction", "x", "forceRepulsion", "getDisp", "getOffset", "limitMaximumDisplacement", "positionCluster", "positionNodes", "randomize", "run", "shiftX", "shiftY", "setDisp", "disp", "setEdgeRenderer", "renderer", "shiftCoordinates", "Companion", "NodeCluster", "graphview_release"})
public final class FruchtermanReingoldAlgorithm
implements Layout {
    private EdgeRenderer edgeRenderer;
    private final Map<Node, VectorF> disps;
    private final Random rand;
    private int width;
    private int height;
    private float k;
    private float t;
    private float attraction_k;
    private float repulsion_k;
    private final int iterations;
    public static final int DEFAULT_ITERATIONS = 1000;
    public static final int CLUSTER_PADDING = 100;
    private static final double EPSILON = 1.0E-4;
    private static final long SEED = 401678L;
    public static final Companion Companion = new Companion(null);

    private final void randomize(List<Node> nodes) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            this.disps.put(node, new VectorF(0.0f, 0.0f, 3, null));
            node.setPosition(FruchtermanReingoldAlgorithm.Companion.randInt(this.rand, 0, this.width / 2), FruchtermanReingoldAlgorithm.Companion.randInt(this.rand, 0, this.height / 2));
        }
    }

    private final void cool(int currentIteration) {
        this.t *= 1.0f - (float)currentIteration / (float)this.iterations;
    }

    private final void limitMaximumDisplacement(List<Node> nodes) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            double d = 1.0E-4;
            double d2 = this.getDisp(it).length();
            boolean bl2 = false;
            float dispLength = (float)Math.max(d, d2);
            float f = this.t;
            VectorF vectorF = this.getDisp(it).divide(dispLength);
            VectorF vectorF2 = it.getPosition();
            Node node = it;
            boolean bl3 = false;
            float f2 = Math.min(dispLength, f);
            node.setPosition(vectorF2.add(vectorF.multiply(f2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateAttraction(List<Edge> edges) {
        Iterable $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void v;
            Edge $dstr$v$u = (Edge)element$iv;
            boolean bl = false;
            Node node = $dstr$v$u.component1();
            Node u = $dstr$v$u.component2();
            VectorF delta = v.getPosition().subtract(u.getPosition());
            double d = 1.0E-4;
            double d2 = delta.length();
            boolean bl2 = false;
            float deltaLength = (float)Math.max(d, d2);
            this.setDisp((Node)v, this.getDisp((Node)v).subtract(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
            this.setDisp(u, this.getDisp(u).add(delta.divide(deltaLength).multiply(this.forceAttraction(deltaLength))));
        }
    }

    private final void calculateRepulsion(List<Node> nodes) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node v = (Node)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = nodes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node u = (Node)element$iv2;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)u, (Object)v) ^ true)) continue;
                VectorF delta = v.getPosition().subtract(u.getPosition());
                double d = 1.0E-4;
                double d2 = delta.length();
                boolean bl3 = false;
                float deltaLength = (float)Math.max(d, d2);
                this.setDisp(v, this.getDisp(v).add(delta.divide(deltaLength).multiply(this.forceRepulsion(deltaLength))));
            }
        }
    }

    private final float forceAttraction(float x) {
        return x * x / this.attraction_k;
    }

    private final float forceRepulsion(float x) {
        return this.repulsion_k * this.repulsion_k / x;
    }

    private final VectorF getDisp(Node node) {
        return (VectorF)MapsKt.getValue(this.disps, (Object)node);
    }

    private final void setDisp(Node node, VectorF disp) {
        this.disps.put(node, disp);
    }

    @Override
    @NotNull
    public Size run(@NotNull Graph graph, float shiftX, float shiftY) {
        int size;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        this.width = size = this.findBiggestSize(graph) * graph.getNodeCount();
        this.height = size;
        List<Node> nodes = graph.getNodes();
        List<Edge> edges = graph.getEdges();
        double d = (float)this.width / 2.0f * (float)this.height / 2.0f;
        double d2 = 0.1;
        FruchtermanReingoldAlgorithm fruchtermanReingoldAlgorithm = this;
        boolean bl = false;
        double d3 = Math.sqrt(d);
        fruchtermanReingoldAlgorithm.t = (float)(d2 * d3);
        d = (float)(this.width * this.height) / (float)nodes.size();
        d2 = 0.75;
        fruchtermanReingoldAlgorithm = this;
        bl = false;
        d3 = Math.sqrt(d);
        fruchtermanReingoldAlgorithm.k = (float)(d2 * d3);
        this.attraction_k = 0.75f * this.k;
        this.repulsion_k = 0.75f * this.k;
        this.randomize(nodes);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.iterations);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            this.calculateRepulsion(nodes);
            this.calculateAttraction(edges);
            this.limitMaximumDisplacement(nodes);
            this.cool(i);
            if (!this.done()) continue;
        }
        this.positionNodes(graph);
        this.shiftCoordinates(graph, shiftX, shiftY);
        return this.calculateGraphSize(graph);
    }

    private final void shiftCoordinates(Graph graph, float shiftX, float shiftY) {
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            node.setPosition(new VectorF(node.getX() + shiftX, node.getY() + shiftY));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void positionNodes(Graph graph) {
        Node node;
        VectorF vectorF = this.getOffset(graph);
        float f = vectorF.component1();
        float y = vectorF.component2();
        ArrayList<Node> nodesVisited = new ArrayList<Node>();
        ArrayList<NodeCluster> nodeClusters = new ArrayList<NodeCluster>();
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void x;
            node = (Node)element$iv;
            boolean bl = false;
            node.setPosition(new VectorF(node.getX() - x, node.getY() - y));
        }
        $this$forEach$iv = graph.getNodes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            node = (Node)element$iv;
            boolean bl = false;
            if (nodesVisited.contains(node)) continue;
            nodesVisited.add(node);
            NodeCluster cluster = this.findClusterOf((List<NodeCluster>)nodeClusters, node);
            if (cluster == null) {
                cluster = new NodeCluster();
                cluster.add(node);
                nodeClusters.add(cluster);
            }
            this.followEdges(graph, cluster, node, (List<Node>)nodesVisited);
        }
        this.positionCluster((List<NodeCluster>)nodeClusters);
    }

    /*
     * WARNING - void declaration
     */
    private final void positionCluster(List<NodeCluster> nodeClusters) {
        this.combineSingleNodeCluster(nodeClusters);
        NodeCluster cluster = nodeClusters.get(0);
        cluster.offset(-cluster.getRect().left, -cluster.getRect().top);
        int n = 1;
        int n2 = nodeClusters.size();
        while (n < n2) {
            void i;
            NodeCluster nextCluster = nodeClusters.get((int)i);
            float xDiff = nextCluster.getRect().left - cluster.getRect().right - (float)100;
            float yDiff = nextCluster.getRect().top - cluster.getRect().top;
            nextCluster.offset(-xDiff, -yDiff);
            cluster = nextCluster;
            ++i;
        }
    }

    private final void combineSingleNodeCluster(List<NodeCluster> nodeClusters) {
        NodeCluster firstSingleNodeCluster = null;
        Iterator<NodeCluster> iterator = nodeClusters.iterator();
        while (iterator.hasNext()) {
            NodeCluster cluster = iterator.next();
            if (cluster.size() != 1) continue;
            if (firstSingleNodeCluster == null) {
                firstSingleNodeCluster = cluster;
                continue;
            }
            firstSingleNodeCluster.concat(cluster);
            iterator.remove();
        }
    }

    private final void followEdges(Graph graph, NodeCluster cluster, Node node, List<Node> nodesVisited) {
        Iterable $this$forEach$iv = graph.successorsOf(node);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node successor = (Node)element$iv;
            boolean bl = false;
            if (nodesVisited.contains(successor)) continue;
            nodesVisited.add(successor);
            cluster.add(successor);
            this.followEdges(graph, cluster, successor, nodesVisited);
        }
        $this$forEach$iv = graph.predecessorsOf(node);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node predecessor = (Node)element$iv;
            boolean bl = false;
            if (nodesVisited.contains(predecessor)) continue;
            nodesVisited.add(predecessor);
            cluster.add(predecessor);
            this.followEdges(graph, cluster, predecessor, nodesVisited);
        }
    }

    private final NodeCluster findClusterOf(List<NodeCluster> clusters, Node node) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = clusters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NodeCluster it = (NodeCluster)element$iv;
                boolean bl = false;
                if (!it.contains(node)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final int findBiggestSize(Graph graph) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = graph.getNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Node node = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = it.getHeight();
            int n2 = it.getWidth();
            boolean bl2 = false;
            Integer n3 = Math.max(n, n2);
            collection.add(n3);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return n != null ? n : 0;
    }

    private final VectorF getOffset(Graph graph) {
        float offsetX = Float.MAX_VALUE;
        float offsetY = Float.MAX_VALUE;
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float f;
            Node node = (Node)element$iv;
            boolean bl = false;
            float f2 = offsetX;
            float f3 = node.getX();
            boolean bl2 = false;
            offsetX = f = Math.min(f2, f3);
            f2 = offsetY;
            f3 = node.getY();
            bl2 = false;
            offsetY = f = Math.min(f2, f3);
        }
        return new VectorF(offsetX, offsetY);
    }

    private final boolean done() {
        int n = this.height;
        int n2 = this.width;
        double d = 1.0;
        double d2 = this.t;
        boolean bl = false;
        int n3 = Math.max(n, n2);
        return d2 < d / (double)n3;
    }

    @Override
    public void drawEdges(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint linePaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)linePaint, (String)"linePaint");
        this.edgeRenderer.render(canvas, graph, linePaint);
    }

    @Override
    public void setEdgeRenderer(@NotNull EdgeRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        this.edgeRenderer = renderer;
    }

    private final Size calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (Node node : graph.getNodes()) {
            float f = left;
            float f2 = node.getX();
            boolean bl = false;
            left = (int)Math.min(f, f2);
            f = top;
            f2 = node.getY();
            bl = false;
            top = (int)Math.min(f, f2);
            f = right;
            f2 = node.getX() + (float)node.getWidth();
            bl = false;
            right = (int)Math.max(f, f2);
            f = bottom;
            f2 = node.getY() + (float)node.getHeight();
            bl = false;
            bottom = (int)Math.max(f, f2);
        }
        return new Size(right - left, bottom - top);
    }

    @JvmOverloads
    public FruchtermanReingoldAlgorithm(int iterations) {
        this.iterations = iterations;
        this.edgeRenderer = new ArrowEdgeRenderer();
        this.disps = new HashMap();
        this.rand = new Random(401678L);
    }

    public /* synthetic */ FruchtermanReingoldAlgorithm(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        this(n);
    }

    @JvmOverloads
    public FruchtermanReingoldAlgorithm() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0000J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u001bR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lde/blox/graphview/energy/FruchtermanReingoldAlgorithm$NodeCluster;", "", "()V", "nodes", "Ljava/util/ArrayList;", "Lde/blox/graphview/Node;", "Lkotlin/collections/ArrayList;", "getNodes", "()Ljava/util/ArrayList;", "rect", "Landroid/graphics/RectF;", "getRect", "()Landroid/graphics/RectF;", "setRect", "(Landroid/graphics/RectF;)V", "add", "", "node", "concat", "cluster", "contains", "", "offset", "xDiff", "", "yDiff", "size", "", "graphview_release"})
    private static final class NodeCluster {
        @NotNull
        private final ArrayList<Node> nodes;
        @NotNull
        private RectF rect;

        @NotNull
        public final ArrayList<Node> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final RectF getRect() {
            return this.rect;
        }

        public final void setRect(@NotNull RectF rectF) {
            Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
            this.rect = rectF;
        }

        public final void add(@NotNull Node node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.nodes.add(node);
            if (this.nodes.size() == 1) {
                RectF rectF = this.rect;
                boolean bl = false;
                boolean bl2 = false;
                RectF $this$apply = rectF;
                boolean bl3 = false;
                $this$apply.left = node.getX();
                $this$apply.top = node.getY();
                $this$apply.right = node.getX() + (float)node.getWidth();
                $this$apply.bottom = node.getY() + (float)node.getHeight();
            } else {
                float f;
                RectF rectF = this.rect;
                boolean bl = false;
                boolean bl4 = false;
                RectF $this$apply = rectF;
                boolean bl5 = false;
                float f2 = $this$apply.left;
                float f3 = node.getX();
                RectF rectF2 = $this$apply;
                boolean bl6 = false;
                rectF2.left = f = Math.min(f2, f3);
                f2 = $this$apply.top;
                f3 = node.getY();
                rectF2 = $this$apply;
                bl6 = false;
                rectF2.top = f = Math.min(f2, f3);
                f2 = $this$apply.right;
                f3 = node.getX() + (float)node.getWidth();
                rectF2 = $this$apply;
                bl6 = false;
                rectF2.right = f = Math.max(f2, f3);
                f2 = $this$apply.bottom;
                f3 = node.getY() + (float)node.getHeight();
                rectF2 = $this$apply;
                bl6 = false;
                rectF2.bottom = f = Math.max(f2, f3);
            }
        }

        public final boolean contains(@NotNull Node node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.nodes.contains(node);
        }

        public final int size() {
            return this.nodes.size();
        }

        public final void concat(@NotNull NodeCluster cluster) {
            Intrinsics.checkParameterIsNotNull((Object)cluster, (String)"cluster");
            Iterable $this$forEach$iv = cluster.nodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                node.setPosition(new VectorF(this.rect.right + (float)100, this.rect.top));
                this.add(node);
            }
        }

        public final void offset(float xDiff, float yDiff) {
            Iterable $this$forEach$iv = this.nodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node node = (Node)element$iv;
                boolean bl = false;
                node.setPosition(node.getPosition().add(xDiff, yDiff));
            }
            this.rect.offset(xDiff, yDiff);
        }

        public NodeCluster() {
            NodeCluster nodeCluster = this;
            boolean bl = false;
            ArrayList arrayList = new ArrayList();
            nodeCluster.nodes = arrayList;
            this.rect = new RectF();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/blox/graphview/energy/FruchtermanReingoldAlgorithm$Companion;", "", "()V", "CLUSTER_PADDING", "", "DEFAULT_ITERATIONS", "EPSILON", "", "SEED", "", "randInt", "rand", "Ljava/util/Random;", "min", "max", "graphview_release"})
    public static final class Companion {
        private final int randInt(Random rand, int min, int max) {
            return rand.nextInt(max - min + 1) + min;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

