/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import de.blox.graphview.Edge;
import de.blox.graphview.GraphObserver;
import de.blox.graphview.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u001b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u001f\u0010\u001c\u001a\u00020\u00182\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\bJ\u001f\u0010!\u001a\u00020\u00182\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001d\"\u00020\b\u00a2\u0006\u0002\u0010\"J\u0011\u0010#\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bH\u0086\u0002J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0001J\u0018\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010 \u001a\u00020\bJ\u0010\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0001J\u000e\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0012J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010 \u001a\u00020\bJ\u0006\u0010+\u001a\u00020\u0010J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\u000e\u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\bJ\b\u0010.\u001a\u00020\u0018H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010 \u001a\u00020\bJ\u000e\u00100\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bJ\u001f\u00103\u001a\u00020\u00182\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001eJ\u000e\u00104\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\bJ\u001f\u00105\u001a\u00020\u00182\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u001d\"\u00020\b\u00a2\u0006\u0002\u0010\"J\u000e\u00106\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010 \u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0004j\b\u0012\u0004\u0012\u00020\b`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u0004j\b\u0012\u0004\u0012\u00020\u000e`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u00068"}, d2={"Lde/blox/graphview/Graph;", "", "()V", "_edges", "Ljava/util/ArrayList;", "Lde/blox/graphview/Edge;", "Lkotlin/collections/ArrayList;", "_nodes", "Lde/blox/graphview/Node;", "edges", "", "getEdges", "()Ljava/util/List;", "graphObserver", "Lde/blox/graphview/GraphObserver;", "isTree", "", "nodeCount", "", "getNodeCount", "()I", "nodes", "getNodes", "addEdge", "", "edge", "source", "destination", "addEdges", "", "([Lde/blox/graphview/Edge;)V", "addNode", "node", "addNodes", "([Lde/blox/graphview/Node;)V", "contains", "containsData", "data", "getEdgeBetween", "getInEdges", "getNodeAtPosition", "position", "getOutEdges", "hasNodes", "hasPredecessor", "hasSuccessor", "notifyGraphObserver", "predecessorsOf", "removeEdge", "predecessor", "current", "removeEdges", "removeNode", "removeNodes", "setAsTree", "successorsOf", "graphview_release"})
public final class Graph {
    private final ArrayList<Node> _nodes;
    private final ArrayList<Edge> _edges;
    private final ArrayList<GraphObserver> graphObserver;
    @NotNull
    private final List<Node> nodes;
    @NotNull
    private final List<Edge> edges;
    private boolean isTree;

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final List<Edge> getEdges() {
        return this.edges;
    }

    public final int getNodeCount() {
        return this._nodes.size();
    }

    public final void addNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!this._nodes.contains(node)) {
            this._nodes.add(node);
            this.notifyGraphObserver();
        }
    }

    public final void addNodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        Node[] $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        Node[] nodeArray = $this$forEach$iv;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node element$iv;
            Node it = element$iv = nodeArray[i];
            boolean bl = false;
            this.addNode(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (!this._nodes.contains(node)) {
            throw (Throwable)new IllegalArgumentException("Unable to find node in graph.");
        }
        if (this.isTree) {
            for (Node n : this.successorsOf(node)) {
                this.removeNode(n);
            }
        }
        this._nodes.remove(node);
        Iterator<Edge> iterator = this._edges.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"_edges.iterator()");
        Iterator<Edge> iterator2 = iterator;
        while (iterator2.hasNext()) {
            void source;
            Edge edge = iterator2.next();
            Node node2 = edge.component1();
            Node destination = edge.component2();
            if (!Intrinsics.areEqual((Object)source, (Object)node) && !Intrinsics.areEqual((Object)destination, (Object)node)) continue;
            iterator2.remove();
        }
        this.notifyGraphObserver();
    }

    public final void removeNodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        Node[] $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        Node[] nodeArray = $this$forEach$iv;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node element$iv;
            Node it = element$iv = nodeArray[i];
            boolean bl = false;
            this.removeNode(it);
        }
    }

    @NotNull
    public final Edge addEdge(@NotNull Node source, @NotNull Node destination) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Edge edge = new Edge(source, destination);
        this.addEdge(edge);
        return edge;
    }

    public final void addEdge(@NotNull Edge edge) {
        Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
        this.addNode(edge.getSource());
        this.addNode(edge.getDestination());
        if (!this._edges.contains(edge)) {
            this._edges.add(edge);
            this.notifyGraphObserver();
        }
    }

    public final void addEdges(Edge ... edges) {
        Intrinsics.checkParameterIsNotNull((Object)edges, (String)"edges");
        Edge[] $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        Edge[] edgeArray = $this$forEach$iv;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge element$iv;
            Edge it = element$iv = edgeArray[i];
            boolean bl = false;
            this.addEdge(it);
        }
    }

    public final boolean removeEdge(@NotNull Edge edge) {
        Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
        return this._edges.remove(edge);
    }

    public final void removeEdges(Edge ... edges) {
        Intrinsics.checkParameterIsNotNull((Object)edges, (String)"edges");
        Edge[] $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        Edge[] edgeArray = $this$forEach$iv;
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge element$iv;
            Edge it = element$iv = edgeArray[i];
            boolean bl = false;
            this.removeEdge(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeEdge(@NotNull Node predecessor, @NotNull Node current) {
        Intrinsics.checkParameterIsNotNull((Object)predecessor, (String)"predecessor");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        Iterator<Edge> iterator = this._edges.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"_edges.iterator()");
        Iterator<Edge> iterator2 = iterator;
        while (iterator2.hasNext()) {
            void source;
            Edge edge = iterator2.next();
            Node node = edge.component1();
            Node destination = edge.component2();
            if (!Intrinsics.areEqual((Object)source, (Object)predecessor) || !Intrinsics.areEqual((Object)destination, (Object)current)) continue;
            iterator2.remove();
        }
    }

    public final boolean hasNodes() {
        Collection collection = this._nodes;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final Node getNodeAtPosition(int position) {
        if (position < 0) {
            throw (Throwable)new IllegalArgumentException("position can't be negative");
        }
        int size = this._nodes.size();
        if (position >= size) {
            throw (Throwable)new IndexOutOfBoundsException("Position: " + position + ", Size: " + size);
        }
        Node node = this._nodes.get(position);
        Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"_nodes[position]");
        return node;
    }

    @Nullable
    public final Edge getEdgeBetween(@NotNull Node source, @NotNull Node destination) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            Iterable iterable = this._edges;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Edge it = (Edge)t;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getSource(), (Object)source) && Intrinsics.areEqual((Object)it.getDestination(), (Object)destination))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean hasSuccessor(@NotNull Node node) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Iterable $this$any$iv = this._edges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Edge it = (Edge)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getSource(), (Object)node)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Node> successorsOf(@NotNull Node node) {
        void $this$mapTo$iv$iv;
        Edge it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Iterable $this$filter$iv = this._edges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Edge)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSource(), (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void edge;
            it = (Edge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node2 = edge.getDestination();
            collection.add(node2);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasPredecessor(@NotNull Node node) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Iterable $this$any$iv = this._edges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Edge it = (Edge)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDestination(), (Object)node)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Node> predecessorsOf(@NotNull Node node) {
        void $this$mapTo$iv$iv;
        Edge it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Iterable $this$filter$iv = this._edges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Edge)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDestination(), (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void edge;
            it = (Edge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node2 = edge.getSource();
            collection.add(node2);
        }
        return (List)destination$iv$iv;
    }

    public final boolean contains(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this._nodes.contains(node);
    }

    public final boolean contains(@NotNull Edge edge) {
        Intrinsics.checkParameterIsNotNull((Object)edge, (String)"edge");
        return this._edges.contains(edge);
    }

    public final boolean containsData(@NotNull Object data) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Iterable $this$any$iv = this._nodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Node it = (Node)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getData(), (Object)data)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final Node getNodeAtPosition(@NotNull Object data) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Iterable iterable = this._nodes;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Node node = (Node)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)node.getData(), (Object)data)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge> getOutEdges(@NotNull Node node) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Iterable $this$filter$iv = this._edges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Edge it = (Edge)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSource(), (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Edge> getInEdges(@NotNull Node node) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Iterable $this$filter$iv = this._edges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Edge it = (Edge)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDestination(), (Object)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void setAsTree(boolean isTree) {
        this.isTree = isTree;
    }

    private final void notifyGraphObserver() {
        Iterable $this$forEach$iv = this.graphObserver;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphObserver it = (GraphObserver)element$iv;
            boolean bl = false;
            it.notifyGraphInvalidated();
        }
    }

    public Graph() {
        Graph graph = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        graph._nodes = arrayList;
        graph = this;
        bl = false;
        arrayList = new ArrayList();
        graph._edges = arrayList;
        graph = this;
        bl = false;
        arrayList = new ArrayList();
        graph.graphObserver = arrayList;
        this.nodes = this._nodes;
        this.edges = this._edges;
    }
}

