/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.layered;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.edgerenderer.ArrowEdgeRenderer;
import de.blox.graphview.layered.SugiyamaEdgeData;
import java.util.List;
import java.util.Map;

public class SugiyamaEdgeRenderer
extends ArrowEdgeRenderer {
    private Map<Edge, SugiyamaEdgeData> edgeData;

    SugiyamaEdgeRenderer(Map<Edge, SugiyamaEdgeData> edgeData) {
        this.edgeData = edgeData;
    }

    @Override
    public void render(Canvas canvas, Graph graph, Paint paint) {
        Paint trianglePaint = new Paint(paint);
        trianglePaint.setStyle(Paint.Style.FILL);
        Path path = new Path();
        for (Edge edge : graph.getEdges()) {
            float[] clippedLine;
            Node source = edge.getSource();
            Vector sourcePosition = source.getPosition();
            Node destination = edge.getDestination();
            Vector destinationPosition = destination.getPosition();
            if (this.edgeData.get((Object)edge).bendPoints.isEmpty()) {
                float startX = sourcePosition.getX() + (float)source.getWidth() / 2.0f;
                float startY = sourcePosition.getY() + (float)source.getHeight() / 2.0f;
                float stopX = destinationPosition.getX() + (float)destination.getWidth() / 2.0f;
                float stopY = destinationPosition.getY() + (float)destination.getHeight() / 2.0f;
                clippedLine = this.clipLine(startX, startY, stopX, stopY, destination);
                canvas.drawLine(clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3], paint);
            } else {
                List<Float> bendPoints = this.edgeData.get((Object)edge).bendPoints;
                int size = bendPoints.size();
                path.reset();
                path.moveTo(bendPoints.get(0).floatValue(), bendPoints.get(1).floatValue());
                for (int i = 3; i < size; i += 2) {
                    path.lineTo(bendPoints.get(i - 1).floatValue(), bendPoints.get(i).floatValue());
                }
                canvas.drawPath(path, paint);
                clippedLine = this.clipLine(bendPoints.get(size - 4).floatValue(), bendPoints.get(size - 3).floatValue(), bendPoints.get(size - 2).floatValue(), bendPoints.get(size - 1).floatValue(), destination);
            }
            this.drawTriangle(canvas, trianglePaint, clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3]);
        }
    }
}

