/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.EdgeRenderer;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import java.util.List;

class TreeEdgeRenderer
implements EdgeRenderer {
    private BuchheimWalkerConfiguration configuration;

    TreeEdgeRenderer(BuchheimWalkerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void render(Canvas canvas, Graph graph, Paint paint) {
        Path linePath = new Path();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            List<Node> children = graph.successorsOf(node);
            for (Node child : children) {
                switch (this.configuration.getOrientation()) {
                    case 1: {
                        linePath.moveTo(child.getX() + (float)(child.getWidth() / 2), child.getY());
                        linePath.lineTo(child.getX() + (float)(child.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.moveTo(node.getX() + (float)(node.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), node.getY() + (float)node.getHeight());
                        canvas.drawPath(linePath, paint);
                        break;
                    }
                    case 2: {
                        linePath.moveTo(child.getX() + (float)(child.getWidth() / 2), child.getY() + (float)child.getHeight());
                        linePath.lineTo(child.getX() + (float)(child.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.moveTo(node.getX() + (float)(node.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), node.getY() + (float)node.getHeight());
                        canvas.drawPath(linePath, paint);
                        break;
                    }
                    case 3: {
                        linePath.moveTo(child.getX(), child.getY() + (float)(child.getHeight() / 2));
                        linePath.lineTo(child.getX() - (float)(this.configuration.getLevelSeparation() / 2), child.getY() + (float)(child.getHeight() / 2));
                        linePath.lineTo(node.getX() + (float)(node.getWidth() + this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        linePath.moveTo(node.getX() + (float)node.getWidth() + (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)(node.getHeight() / 2));
                        canvas.drawPath(linePath, paint);
                        break;
                    }
                    case 4: {
                        linePath.moveTo(child.getX() + (float)child.getWidth(), child.getY() + (float)(child.getHeight() / 2));
                        linePath.lineTo(child.getX() + (float)child.getWidth() + (float)(this.configuration.getLevelSeparation() / 2), child.getY() + (float)(child.getHeight() / 2));
                        linePath.lineTo(node.getX() - (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        linePath.moveTo(node.getX() - (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)(node.getHeight() / 2));
                        canvas.drawPath(linePath, paint);
                    }
                }
            }
        }
    }
}

