/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

public class Vector {
    private final float x;
    private final float y;

    public Vector() {
        this(0.0f, 0.0f);
    }

    public Vector(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector add(Vector operand) {
        return new Vector(operand.x + this.x, operand.y + this.y);
    }

    public Vector subtract(Vector operand) {
        return new Vector(this.x - operand.x, this.y - operand.y);
    }

    public Vector multiply(Vector operand) {
        return new Vector(this.x * operand.x, this.y * operand.y);
    }

    public Vector multiply(float operand) {
        return new Vector(this.x * operand, this.y * operand);
    }

    public Vector divide(Vector operand) {
        return new Vector(this.x / operand.x, this.y / operand.y);
    }

    public Vector divide(float operand) {
        return new Vector(this.x / operand, this.y / operand);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public String toString() {
        return "Vector{x=" + this.x + ", y=" + this.y + '}';
    }
}

