/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

public class Vector {
    private final double x;
    private final double y;

    public Vector() {
        this(0.0, 0.0);
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector add(Vector operand) {
        return new Vector(operand.x + this.x, operand.y + this.y);
    }

    public Vector subtract(Vector operand) {
        return new Vector(this.x - operand.x, this.y - operand.y);
    }

    public Vector multiply(Vector operand) {
        return new Vector(this.x * operand.x, this.y * operand.y);
    }

    public Vector multiply(double operand) {
        return new Vector(this.x * operand, this.y * operand);
    }

    public Vector divide(Vector operand) {
        return new Vector(this.x / operand.x, this.y / operand.y);
    }

    public Vector divide(double operand) {
        return new Vector(this.x / operand, this.y / operand);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "Vector{x=" + this.x + ", y=" + this.y + '}';
    }
}

