/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;

@ManagedBean
@ViewScoped
public class I18n
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.core.i18n.I18n");
    private static final long serialVersionUID = 1L;
    Locale locale;
    HashMap<String, String> translations = new HashMap();
    String json = "";

    @PostConstruct
    public void loadMessageBundles() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.locale = context.getExternalContext().getRequestLocale();
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        InputStream i18n = this.getClass().getClassLoader().getResourceAsStream("i18n_" + language + "_" + country + ".properties");
        if (null == i18n) {
            i18n = this.getClass().getClassLoader().getResourceAsStream("i18n_" + language + ".properties");
        }
        if (null == i18n) {
            i18n = this.getClass().getClassLoader().getResourceAsStream("i18n.properties");
        }
        if (null == i18n) {
            i18n = this.getClass().getClassLoader().getResourceAsStream("i18n_en.properties");
        }
        if (null != i18n) {
            String i18nContents = I18n.slurp(i18n, 4096);
            if (null != i18nContents) {
                String[] lines;
                for (String line : lines = i18nContents.split("\n")) {
                    this.json = this.convertPropertyFileLineToJSon(line, this.json);
                }
                this.json = this.json.length() > 1 ? "{" + this.json.substring(1) + "}" : "{}";
            }
            try {
                i18n.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String convertPropertyFileLineToJSon(String line, String json) {
        String rest;
        String english;
        if (line == null) {
            return json;
        }
        String l = line.trim();
        if (l.length() == 0 || l.startsWith("//")) {
            return json;
        }
        boolean inString = l.startsWith("\"");
        if (inString) {
            int i;
            boolean esc = false;
            for (i = 1; i < l.length(); ++i) {
                if (esc) {
                    esc = false;
                    continue;
                }
                if (l.charAt(i) == '\\') {
                    esc = true;
                    continue;
                }
                if (l.charAt(i) != '\"') continue;
                ++i;
                break;
            }
            english = l.substring(1, i - 1).replace("\\\"", "\"");
            rest = l.substring(i).trim();
        } else {
            int pos = l.indexOf(61);
            if (pos < 0) {
                LOGGER.severe("Illegal entry in language file: \"" + line + "\"");
                return json;
            }
            english = l.substring(0, pos).trim();
            rest = l.substring(pos);
        }
        if (!rest.startsWith("=")) {
            LOGGER.severe("Illegal entry in language file: \"" + line + "\"");
        } else {
            int pos;
            String translation = (rest = rest.substring(1).trim()).startsWith("\"") ? ((pos = rest.lastIndexOf("\"")) > 1 ? rest.substring(1, pos).replace("\\\"", "\"").trim() : rest.replace("\\\"", "\"")) : rest;
            this.translations.put(english, translation);
            json = json + ", \"" + english + "\"" + "," + "\"" + translation + "\"";
        }
        return json;
    }

    public String getMessageBundleAsJSon() {
        return this.json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(InputStream is, int bufferSize) {
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        try {
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            try {
                int rsz;
                while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    out.append(buffer, 0, rsz);
                }
            }
            finally {
                ((Reader)in).close();
            }
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return out.toString();
    }

    public String translate(String english) {
        if (null == this.translations || this.translations.isEmpty() || english == null) {
            return english;
        }
        if (this.translations.containsKey(english)) {
            return this.translations.get(english);
        }
        if (this.translations.containsKey(english = english.trim())) {
            return this.translations.get(english);
        }
        return english;
    }
}

