/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation.stoneQuarry;

import de.beyondjava.angularFaces.components.puiModelSync.PuiModelSync;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import de.beyondjava.angularFaces.core.transformation.stoneQuarry.JSFAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;

public class ProcessAngularExpressionsCallback
implements VisitCallback {
    private static final Pattern angularExpression = Pattern.compile("\\{\\{([A-Z]|[a-z]|\\.)+\\}\\}");
    static final String identifier = "([A-Z]|[a-z]|[0-9]|_|\\.)+";
    private static final Pattern ngRepeat = Pattern.compile("ng-repeat=\"([A-Z]|[a-z]|[0-9]|_|\\.)+\\sin\\s(\\$)?([A-Z]|[a-z]|[0-9]|_|\\.)+");

    public VisitResult visit(VisitContext arg0, UIComponent component) {
        if (component.getClass().getName().endsWith(".UIInstructions")) {
            String html = component.toString();
            ProcessAngularExpressionsCallback.addAngularExpressionToJSFAttributeList(html, false);
        } else {
            String cacheable = AttributeUtilities.getAttributeAsString(component, "cacheable");
            boolean isCacheable = "true".equalsIgnoreCase(cacheable);
            for (String key : JSFAttributes.jsfAttributes) {
                this.extractAttribute(component, key, isCacheable);
            }
        }
        return VisitResult.ACCEPT;
    }

    private void extractAttribute(UIComponent component, String key, boolean isCacheable) {
        Object value = AttributeUtilities.getAttribute(component, key);
        if (value != null && value instanceof String) {
            String vs = (String)value;
            ProcessAngularExpressionsCallback.addAngularExpressionToJSFAttributeList(vs, isCacheable);
        }
    }

    private static void addAngularExpressionToJSFAttributeList(String html, boolean cacheable) {
        String exp;
        Matcher matcher = angularExpression.matcher(html);
        while (matcher.find()) {
            exp = matcher.group();
            PuiModelSync.addJSFAttrbitute(exp.substring(2, exp.length() - 2), null, cacheable, false);
        }
        matcher = ngRepeat.matcher(html);
        while (matcher.find()) {
            exp = matcher.group();
            int index = exp.indexOf(" in ");
            if (index < 0) continue;
            String var = exp.substring(index + 4).trim();
            if (var.startsWith("$")) {
                var = var.substring(1);
            }
            PuiModelSync.addJSFAttrbitute(var, null, cacheable, false);
        }
    }
}

