/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.tagTransformer;

import de.beyondjava.angularFaces.core.tagTransformer.TagAttributeUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.faces.view.Location;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;

public final class AFTagAttributes
extends TagAttributes {
    private TagAttribute[] attrs;
    private Tag tag;

    public AFTagAttributes(TagAttribute[] attrs) {
        this.init(attrs);
    }

    private void init(TagAttribute[] attrs) {
        this.attrs = attrs;
    }

    public void addAttribute(Location location, String ns, String myLocalName, String qName, String value) {
        TagAttribute[] newAttrs = Arrays.copyOf(this.attrs, this.attrs.length + 1);
        newAttrs[this.attrs.length] = TagAttributeUtilities.createTagAttribute(location, ns, myLocalName, qName, value);
        this.init(newAttrs);
    }

    public TagAttribute[] getAll() {
        return this.attrs;
    }

    public TagAttribute get(String localName) {
        return this.get("", localName);
    }

    public TagAttribute get(String ns, String localName) {
        if (ns != null && localName != null) {
            for (TagAttribute a : this.attrs) {
                if (!localName.equals(a.getLocalName()) || !ns.equals(a.getNamespace())) continue;
                return a;
            }
        }
        return null;
    }

    public TagAttribute[] getAll(String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        ArrayList<TagAttribute> list = new ArrayList<TagAttribute>();
        for (TagAttribute a : this.attrs) {
            if (!namespace.equals(a.getNamespace())) continue;
            list.add(a);
        }
        TagAttribute[] result = new TagAttribute[list.size()];
        list.toArray(result);
        return result;
    }

    public String[] getNamespaces() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (TagAttribute a : this.attrs) {
            String namespace = a.getNamespace();
            if (m.containsKey(namespace)) continue;
            m.put(namespace, namespace);
        }
        String[] namespaces = new String[m.size()];
        m.values().toArray(namespaces);
        return namespaces;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
        for (TagAttribute a : this.attrs) {
            a.setTag(tag);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.attrs.length; ++i) {
            sb.append(this.attrs[i]);
            sb.append(' ');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

