/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.components.puiLabel;

import de.beyondjava.angularFaces.components.puiLabel.PuiLabel;
import de.beyondjava.angularFaces.components.puiMessage.PuiMessage;
import de.beyondjava.angularFaces.components.puiSync.PuiSync;
import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.angularFaces.core.NGWordUtiltites;
import de.beyondjava.angularFaces.core.i18n.I18n;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import java.io.IOException;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class AddLabelsAndMessagesHandler
extends TagHandler {
    private I18n i18n = null;
    boolean addLabels = true;
    boolean addMessages = true;

    public AddLabelsAndMessagesHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String addMessagesParam;
        String addLabelsParam = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("AngularFaces.addLabels");
        this.addLabels = null == addLabelsParam || "true".equalsIgnoreCase(addLabelsParam);
        boolean isPostBack = FacesContext.getCurrentInstance().isPostback();
        String l = AttributeUtilities.getAttributeAsString(parent, "addLabels");
        if (l != null && "false".equalsIgnoreCase(l)) {
            this.addLabels = false;
        }
        this.addMessages = null == (addMessagesParam = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("AngularFaces.addMessages")) || "true".equalsIgnoreCase(addMessagesParam);
        String m = AttributeUtilities.getAttributeAsString(parent, "addMessages");
        if (m != null && "false".equalsIgnoreCase(m)) {
            this.addMessages = false;
        }
        if (this.addLabels || this.addMessages) {
            this.populateTree(parent, this.addLabels, this.addMessages, isPostBack);
        }
    }

    private void populateTree(UIComponent parent, boolean addLabels, boolean addMessages, boolean isPostBack) {
        List children = parent.getChildren();
        for (int index = children.size() - 1; index >= 0; --index) {
            String m;
            String l;
            UIComponent kid = (UIComponent)children.get(index);
            if (kid instanceof UIInput) {
                if (addMessages) {
                    this.addSingleMessage(children, index, kid, isPostBack);
                }
                if (addLabels) {
                    this.addSingleLabel(children, kid, isPostBack);
                }
            }
            if ((l = AttributeUtilities.getAttributeAsString(kid, "addLabels")) != null) {
                addLabels = !"false".equalsIgnoreCase(l);
            }
            if ((m = AttributeUtilities.getAttributeAsString(kid, "addMessages")) != null) {
                addMessages = !"false".equalsIgnoreCase(m);
            }
            this.populateTree(kid, addLabels, addMessages, isPostBack);
        }
    }

    private void addSingleLabel(List<UIComponent> children, UIComponent kid, boolean isPostback) {
        int index = children.indexOf(kid);
        boolean needsLabel = true;
        String addLabelAttribute = AttributeUtilities.getAttributeAsString(kid, "addLabel");
        if (null != addLabelAttribute && "false".equalsIgnoreCase(addLabelAttribute)) {
            needsLabel = false;
        }
        if (needsLabel) {
            ValueExpression vex;
            String caption = AttributeUtilities.getAttributeAsString(kid, "label");
            if (null == caption && null != (vex = kid.getValueExpression("value"))) {
                String core = vex.getExpressionString();
                caption = NGWordUtiltites.labelFromELExpression(core);
            }
            if (null != caption) {
                UIComponent maybe;
                for (int j = 0; j < children.size(); ++j) {
                    maybe = children.get(j);
                    if (!(maybe instanceof HtmlOutputLabel) || !kid.getId().equals(((HtmlOutputLabel)maybe).getFor())) continue;
                    needsLabel = false;
                }
                if (isPostback) {
                    for (int i = 0; i < children.size(); ++i) {
                        UIComponent forComponent;
                        maybe = children.get(i);
                        if (!(maybe instanceof PuiLabel) || kid != (forComponent = maybe.findComponent(((PuiLabel)maybe).getFor())) || index - 1 == i) continue;
                        needsLabel = false;
                        children.remove(i);
                        children.add(index - 1, maybe);
                    }
                }
                if (needsLabel) {
                    PuiLabel label = new PuiLabel();
                    label.getPassThroughAttributes().put("for", kid.getClientId());
                    kid.getAttributes().put("renderLabel", false);
                    label.setFor(kid.getId());
                    if (null != caption) {
                        String translationParam = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("AngularFaces.translation");
                        if (null == translationParam || "true".equalsIgnoreCase(translationParam)) {
                            label.setValue(this.translate(caption));
                        } else {
                            label.setValue(caption);
                        }
                    }
                    children.add(index, (UIComponent)label);
                }
            }
        }
    }

    private String translate(String caption) {
        if (null == this.i18n) {
            this.i18n = (I18n)ELTools.evalAsObject("#{i18n}");
        }
        if (null == this.i18n) {
            return caption;
        }
        return this.i18n.translate(caption);
    }

    private int addSingleMessage(List<UIComponent> children, int index, UIComponent kid, boolean isPostback) {
        if (kid instanceof UIInput && !(kid instanceof PuiSync)) {
            boolean needsMessage = true;
            String addMessageAttribute = AttributeUtilities.getAttributeAsString(kid, "addMessage");
            if (null != addMessageAttribute && "false".equalsIgnoreCase(addMessageAttribute)) {
                needsMessage = false;
            }
            if (needsMessage) {
                UIComponent forComponent;
                UIComponent maybe;
                if (index < children.size() - 1 && (maybe = children.get(index + 1)) instanceof PuiMessage && kid == (forComponent = maybe.findComponent(((UIMessage)maybe).getFor()))) {
                    needsMessage = false;
                }
                if (needsMessage && isPostback) {
                    for (int i = 0; i < children.size(); ++i) {
                        UIComponent forComponent2;
                        UIComponent maybe2 = children.get(i);
                        if (!(maybe2 instanceof PuiMessage) || kid != (forComponent2 = maybe2.findComponent(((UIMessage)maybe2).getFor()))) continue;
                        needsMessage = false;
                        children.remove(i);
                        children.add(index, maybe2);
                        break;
                    }
                }
                if (needsMessage) {
                    PuiMessage message = new PuiMessage();
                    message.setFor(kid.getId());
                    message.getPassThroughAttributes().put("for", kid.getId());
                    children.add(index + 1, (UIComponent)message);
                }
            }
        }
        return index;
    }
}

