/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.model;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestClassPool {
    private static final Map<Class<?>, TestClass> testClasses = Collections.synchronizedMap(new WeakHashMap());

    private TestClassPool() {
    }

    public static TestClass forClass(Class<?> testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException("TestClass must not be null!");
        }
        if (!testClasses.containsKey(testClass)) {
            testClasses.put(testClass, new TestClass(testClass));
        }
        return testClasses.get(testClass);
    }
}

