/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.processing;

import de.bechte.junit.runners.context.description.Describer;
import de.bechte.junit.runners.context.processing.ChildExecutor;
import de.bechte.junit.runners.context.statements.StatementExecutor;
import de.bechte.junit.runners.context.statements.builder.MethodStatementBuilder;
import de.bechte.junit.runners.util.ReflectionUtil;
import java.util.List;
import java.util.Stack;
import org.junit.Ignore;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExecutor
implements ChildExecutor<FrameworkMethod> {
    protected Describer<FrameworkMethod> describer;
    protected StatementExecutor statementExecutor;
    protected List<MethodStatementBuilder> statementBuilders;

    public MethodExecutor(Describer<FrameworkMethod> describer, StatementExecutor statementExecutor, List<MethodStatementBuilder> statementBuilders) {
        this.describer = describer;
        this.statementExecutor = statementExecutor;
        this.statementBuilders = statementBuilders;
    }

    @Override
    public void run(TestClass testClass, FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describer.describe(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            try {
                Stack<Class<?>> classHierarchy = ReflectionUtil.getClassHierarchy(testClass.getJavaClass());
                Object target = ReflectionUtil.createDeepInstance(classHierarchy);
                Statement statement = this.buildStatement(testClass, method, target, description, notifier);
                for (MethodStatementBuilder builder : this.statementBuilders) {
                    statement = builder.createStatement(testClass, method, target, statement, description, notifier);
                }
                this.statementExecutor.execute(statement, notifier, description);
            }
            catch (Throwable t) {
                this.statementExecutor.execute((Statement)new Fail(t), notifier, description);
            }
        }
    }

    protected Statement buildStatement(TestClass testClass, FrameworkMethod method, Object target, Description description, RunNotifier notifier) {
        return new InvokeMethod(method, target);
    }
}

