/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.DaoException;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;
import java.util.Arrays;

public class PersistentLongArray
extends PersistentField {
    public PersistentLongArray(Field field, int columnIndex) {
        super(field, columnIndex);
        this.mDatabaseDescription = "TEXT";
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException, DaoException {
        long[] longs = this.parseArray(cursor.getString(this.mColumnIndex));
        this.mField.set(domain, longs);
    }

    private long[] parseArray(String string) {
        if ("null".equals(string)) {
            return null;
        }
        String[] split = string.replace("[", "").replace("]", "").split(",");
        long[] longs = new long[split.length];
        for (int i = 0; i < split.length; ++i) {
            longs[i] = Long.parseLong(split[i]);
        }
        return longs;
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        long[] longs = (long[])this.mField.get(domain);
        values.put(this.mColumnName, Arrays.toString(longs));
    }
}

