/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;

public class PersistentEnum
extends PersistentField {
    private Class<?> enumeration;

    public PersistentEnum(Field field, int columnIndex, Class<?> enumeration) {
        super(field, columnIndex);
        if (!enumeration.isEnum()) {
            throw new IllegalArgumentException("class must be enumeration.");
        }
        this.mDatabaseDescription = "INTEGER";
        this.enumeration = enumeration;
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException {
        int ordinal = cursor.getInt(this.mColumnIndex);
        Object value = null;
        if (ordinal > -1) {
            value = this.enumeration.getEnumConstants()[ordinal];
        }
        this.mField.set(domain, value);
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        Object value = this.mField.get(domain);
        int ordinal = -1;
        if (value != null) {
            ordinal = ((Enum)value).ordinal();
        }
        values.put(this.mColumnName, Integer.valueOf(ordinal));
    }
}

