/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;
import java.util.Date;

public class PersistentDate
extends PersistentField {
    public PersistentDate(Field field, int columnIndex) {
        super(field, columnIndex);
        this.mDatabaseDescription = "TEXT";
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException {
        String value = cursor.getString(this.mColumnIndex);
        if (value != null && value.length() > 0) {
            Date date = new Date(Long.parseLong(value));
            this.mField.set(domain, date);
        } else {
            this.mField.set(domain, null);
        }
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        Date date = (Date)this.mField.get(domain);
        if (date != null) {
            values.put(this.mColumnName, date.getTime() + "");
        } else {
            values.put(this.mColumnName, "");
        }
    }
}

