/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence;

import de.neo.android.persistence.Dao;
import de.neo.android.persistence.DaoBuilder;
import de.neo.android.persistence.DatabaseDao;
import de.neo.android.persistence.NeoDataBase;
import java.util.HashMap;
import java.util.Map;

public class DaoFactory {
    private static DaoFactory mSingelton;
    protected Map<Class<?>, Dao<?>> mMapClassDao = new HashMap();
    private NeoDataBase mDatabase;

    public static DaoFactory initiate(DaoBuilder builder) {
        DaoFactory.finilize();
        mSingelton = new DaoFactory(builder);
        for (Dao<?> dao : DaoFactory.mSingelton.mMapClassDao.values()) {
            if (!(dao instanceof DatabaseDao)) continue;
            ((DatabaseDao)dao).initDependencyFields();
        }
        return mSingelton;
    }

    public static void finilize() {
        if (mSingelton != null) {
            if (DaoFactory.mSingelton.mDatabase != null) {
                DaoFactory.mSingelton.mDatabase.close();
            }
            mSingelton = null;
        }
    }

    public static DaoFactory getInstance() {
        if (mSingelton == null) {
            throw new IllegalStateException("factory has not been initiated. call initiate first");
        }
        return mSingelton;
    }

    private DaoFactory(DaoBuilder builder) {
        builder.mDaoMapFilling.createDaos(this.mMapClassDao, builder);
    }

    public <T> Dao<T> getDao(Class<?> domain) {
        return this.mMapClassDao.get(domain);
    }

    public Object getCustomDao(Class<?> domain) {
        return this.mMapClassDao.get(domain);
    }
}

