/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.touchhandler;

import android.os.Bundle;
import android.view.MotionEvent;
import de.neo.android.opengl.touchhandler.AbstractSceneHandler;
import javax.microedition.khronos.opengles.GL10;

public abstract class ZoomableSceneHandler
extends AbstractSceneHandler {
    public float[] zoomBounds = new float[]{0.0f, -40.0f};
    public static final String STATE_SCENE_ZOOM = "common.state.zoom";
    private float div;
    public float zoom = -10.0f;

    @Override
    public void onTouchEvent(MotionEvent event) {
        if (event.getAction() == 2 && event.getPointerCount() == 2) {
            float dx = event.getX(0) - event.getX(1);
            float dy = event.getY(0) - event.getY(1);
            float divn = (float)Math.sqrt(dx * dx + dy * dy);
            if (this.div == 0.0f) {
                this.div = divn;
                return;
            }
            this.zoom += Math.abs(this.zoom) * (divn - this.div) / 250.0f;
            this.zoom = Math.min(this.zoomBounds[0], Math.max(this.zoomBounds[1], this.zoom));
            this.div = divn;
            return;
        }
        this.div = 0.0f;
    }

    @Override
    public void glTransformScene(GL10 gl) {
        gl.glTranslatef(0.0f, 0.0f, this.zoom);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putFloat(STATE_SCENE_ZOOM, this.zoom);
    }

    @Override
    public void onLoadBundle(Bundle bundle) {
        if (bundle.containsKey(STATE_SCENE_ZOOM)) {
            this.zoom = bundle.getFloat(STATE_SCENE_ZOOM);
        }
    }
}

