/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.touchhandler;

import android.os.Bundle;
import android.view.MotionEvent;
import de.neo.android.opengl.figures.GLQuaternion;
import de.neo.android.opengl.touchhandler.ZoomableSceneHandler;
import javax.microedition.khronos.opengles.GL10;

public class TranslateSceneHandler
extends ZoomableSceneHandler {
    public static final String STATE_TRANSLATE_ROTATION = "common.state.scenerotation";
    public static final String STATE_TRANSLATE = "common.state.translate";
    public static final int MIN_TOUCH_DURATION = 60;
    public float[] translateSceneBounds = new float[]{5.0f, -5.0f, 5.0f, -5.0f, 0.0f, 0.0f};
    public GLQuaternion sceneRotation = new GLQuaternion();
    private GLQuaternion plateRotation = new GLQuaternion();
    public float[] translateScene = new float[]{0.0f, 0.0f, 0.0f};
    private long startTouch;
    private float slideX;
    private float slideY;
    private float deltaY;
    private float deltaX;

    @Override
    public void onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        long duration = System.currentTimeMillis() - this.startTouch;
        if (event.getAction() == 0) {
            this.startTouch = System.currentTimeMillis();
            this.slideX = 0.0f;
            this.slideY = 0.0f;
            this.deltaX = 0.0f;
            this.deltaY = 0.0f;
        }
        if (event.getAction() == 1 && duration < 400L && duration > 60L) {
            this.slideX = this.deltaX;
            this.slideY = this.deltaY;
        }
        if (event.getAction() == 2 && event.getHistorySize() > 0) {
            if (event.getPointerCount() == 1 && duration > 60L) {
                this.deltaX = (event.getX() - event.getHistoricalX(event.getHistorySize() - 1)) * 0.004f * Math.abs(this.zoom);
                this.deltaY = (event.getY() - event.getHistoricalY(event.getHistorySize() - 1)) * 0.004f * Math.abs(this.zoom);
                this.translateScene[0] = this.translateScene[0] + this.deltaX;
                this.translateScene[1] = this.translateScene[1] + this.deltaY;
                this.translateScene[0] = Math.min(this.translateSceneBounds[0], Math.max(this.translateSceneBounds[1], this.translateScene[0]));
                this.translateScene[1] = Math.min(this.translateSceneBounds[2], Math.max(this.translateSceneBounds[3], this.translateScene[1]));
            }
            if (event.getPointerCount() > 1 && duration > 60L) {
                GLQuaternion q = new GLQuaternion();
                this.rotateByPitchEvent(event, q, new float[]{0.0f, 1.0f, 0.0f});
                q.multiply(this.plateRotation);
                this.plateRotation.assign(q);
            }
        }
    }

    @Override
    public void glTransformScene(GL10 gl) {
        super.glTransformScene(gl);
        this.sceneRotation.glRotate(gl);
        if (this.slideX != 0.0f || this.slideY != 0.0f) {
            this.translateScene[0] = this.translateScene[0] + this.slideX;
            this.translateScene[1] = this.translateScene[1] + this.slideY;
            this.translateScene[0] = Math.min(this.translateSceneBounds[0], Math.max(this.translateSceneBounds[1], this.translateScene[0]));
            this.translateScene[1] = Math.min(this.translateSceneBounds[2], Math.max(this.translateSceneBounds[3], this.translateScene[1]));
            this.slideX = (float)((double)this.slideX * 0.9);
            this.slideY = (float)((double)this.slideY * 0.9);
        }
        gl.glTranslatef(this.translateScene[0], this.translateScene[2], this.translateScene[1]);
        float[] toCenter = new float[]{(this.translateSceneBounds[0] + this.translateSceneBounds[1]) / 3.0f, (this.translateSceneBounds[2] + this.translateSceneBounds[3]) / 3.0f, (this.translateSceneBounds[4] + this.translateSceneBounds[5]) / 3.0f};
        gl.glTranslatef(-toCenter[0], -toCenter[2], -toCenter[1]);
        this.plateRotation.glRotate(gl);
        gl.glTranslatef(toCenter[0], toCenter[2], toCenter[1]);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putFloatArray(STATE_TRANSLATE_ROTATION, this.sceneRotation.toArray());
        outState.putFloatArray(STATE_TRANSLATE, this.translateScene);
    }

    @Override
    public void onLoadBundle(Bundle bundle) {
        super.onLoadBundle(bundle);
        if (bundle.containsKey(STATE_TRANSLATE_ROTATION)) {
            this.sceneRotation.loadArray(bundle.getFloatArray(STATE_TRANSLATE_ROTATION));
        }
        if (bundle.containsKey(STATE_TRANSLATE)) {
            this.translateScene = bundle.getFloatArray(STATE_TRANSLATE);
        }
    }
}

