/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.touchhandler;

import android.os.Bundle;
import android.view.MotionEvent;
import de.neo.android.opengl.figures.GLQuaternion;
import de.neo.android.opengl.touchhandler.ZoomableSceneHandler;
import javax.microedition.khronos.opengles.GL10;

public class RotateSceneHandler
extends ZoomableSceneHandler {
    public static final String STATE_QUATERNION = "common.state.quaternion";
    private GLQuaternion quaternion;
    private float spin;
    private float[] axis = new float[3];
    private long startTouch;
    private float startX;
    private float startY;

    public RotateSceneHandler() {
        this.quaternion = new GLQuaternion();
    }

    @Override
    public void onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (event.getAction() == 0) {
            this.startX = event.getX();
            this.startY = event.getY();
            this.startTouch = System.currentTimeMillis();
            this.spin = 0.0f;
        }
        if (event.getAction() == 1 && System.currentTimeMillis() - this.startTouch < 400L) {
            float dX = event.getX() - this.startX;
            float dY = event.getY() - this.startY;
            this.spin = (float)(Math.sqrt(dX * dX + dY * dY) / 500.0);
        }
        if (event.getAction() == 2 && event.getHistorySize() > 0) {
            float x = event.getX();
            float oldX = event.getHistoricalX(event.getHistorySize() - 1);
            float y = event.getY();
            float oldY = event.getHistoricalY(event.getHistorySize() - 1);
            this.startTouch = 0L;
            if (event.getPointerCount() == 1) {
                float deltaX = x - oldX;
                float deltaY = y - oldY;
                float angle = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY) / 40.0f;
                this.axis[0] = deltaY;
                this.axis[1] = deltaX;
                this.axis[2] = 0.0f;
                this.quaternion.rotateByAngleAxis(angle, deltaY, deltaX, 0.0f);
            }
            if (event.getPointerCount() > 1) {
                this.rotateByPitchEvent(event, this.quaternion, new float[]{0.0f, 0.0f, 1.0f});
            }
        }
    }

    @Override
    public void onLoadBundle(Bundle bundle) {
        super.onLoadBundle(bundle);
        if (bundle.containsKey(STATE_QUATERNION)) {
            this.quaternion.loadArray(bundle.getFloatArray(STATE_QUATERNION));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putFloatArray(STATE_QUATERNION, this.quaternion.toArray());
    }

    @Override
    public void glTransformScene(GL10 gl) {
        super.glTransformScene(gl);
        if (this.spin > 0.0f) {
            this.quaternion.rotateByAngleAxis(this.spin, this.axis[0], this.axis[1], this.axis[2]);
            this.spin *= 0.99f;
        }
        this.quaternion.glRotate(gl);
    }
}

