/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import de.neo.android.opengl.figures.GLCylinder;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLTorus;
import javax.microedition.khronos.opengles.GL10;

public class GLWheel
extends GLFigure {
    private static float RADIUS_MAJOR = 0.8f;
    private static float RADIUS_MINOR = 0.2f;
    public GLTorus torus;
    public GLFigure[] spokes;

    public GLWheel(int spokeCount, int style) {
        super(style);
        this.torus = new GLTorus(RADIUS_MAJOR, RADIUS_MINOR, style);
        this.torus.mColor[0] = 0.3f;
        this.torus.mColor[1] = 0.171f;
        this.torus.mColor[2] = 0.075f;
        this.spokes = new GLFigure[spokeCount];
        for (int i = 0; i < spokeCount; ++i) {
            this.spokes[i] = new GLCylinder(10, style);
            this.spokes[i].mSize[0] = 0.05f;
            this.spokes[i].mSize[1] = 0.05f;
            this.spokes[i].mSize[2] = (RADIUS_MAJOR - RADIUS_MINOR) * 2.0f;
            this.spokes[i].mRotation.rotateByAngleAxis(Math.PI * (double)i / (double)spokeCount, 0.0f, 1.0f, 0.0f);
            this.spokes[i].mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
            this.spokes[i].mColor[2] = 0.3f;
            this.spokes[i].mColor[1] = 0.3f;
            this.spokes[i].mColor[0] = 0.3f;
        }
    }

    @Override
    protected void onDraw(GL10 gl) {
        for (GLFigure figure : this.spokes) {
            figure.draw(gl);
        }
        this.torus.draw(gl);
    }

    public float getRadius() {
        return RADIUS_MINOR + RADIUS_MAJOR;
    }
}

