/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLBall;
import de.neo.android.opengl.figures.GLFigure;
import javax.microedition.khronos.opengles.GL10;

public class GLSolarSystem
extends GLFigure {
    private GLBall earth;
    private GLBall moon;

    public GLSolarSystem(int style) {
        super(style);
        this.earth = new GLBall(style, 30);
        this.earth.mSize[2] = 1.0f;
        this.earth.mSize[1] = 1.0f;
        this.earth.mSize[0] = 1.0f;
        this.moon = new GLBall(style, 30);
        this.moon.mSize[2] = 0.5f;
        this.moon.mSize[1] = 0.5f;
        this.moon.mSize[0] = 0.5f;
        this.moon.mPosition[0] = 2.5f;
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.earth.draw(gl);
        this.moon.draw(gl);
    }

    public void step(double seconds) {
        this.mRotation.rotateByAngleAxis(seconds * 2.0 * Math.PI / 10.0, 0.0f, 1.0f, 0.0f);
        this.earth.mRotation.rotateByAngleAxis(seconds * 2.0 * Math.PI / 5.0, 0.0f, 1.0f, 0.0f);
    }

    public void setTexture(Bitmap earth_textur, Bitmap moon_textur) {
        this.earth.setTexture(earth_textur);
        this.moon.setTexture(moon_textur);
        this.moon.mColor[2] = 1.0f;
        this.moon.mColor[1] = 1.0f;
        this.moon.mColor[0] = 1.0f;
        this.earth.mColor[2] = 1.0f;
        this.earth.mColor[1] = 1.0f;
        this.earth.mColor[0] = 1.0f;
    }
}

