/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.systems.GLBox;
import de.neo.android.opengl.systems.GLFlatScreen;
import de.neo.android.opengl.systems.GLSwitch;
import javax.microedition.khronos.opengles.GL10;

public class GLMediaServer
extends GLSwitch {
    private GLBox box;
    private GLFlatScreen screen;
    private boolean isPlaying;

    public GLMediaServer(int style, boolean hasScreen) {
        super(style);
        this.box = new GLBox(style);
        if (hasScreen) {
            this.screen = new GLFlatScreen(style, 1.2f, 0.67f, 2.0f);
        }
        this.setPlaying(true);
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.box.mPosition[0] = -0.8f;
        this.box.draw(gl);
        this.box.mPosition[0] = 0.8f;
        this.box.draw(gl);
        if (this.screen != null) {
            this.screen.draw(gl);
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        this.box.setOnClickListener(listener);
        if (this.screen != null) {
            this.screen.setOnClickListener(listener);
        }
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        this.box.setOnLongClickListener(listener);
        if (this.screen != null) {
            this.screen.setOnLongClickListener(listener);
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
        if (!this.isPlaying) {
            this.box.setVolume(50.0f);
        }
    }

    @Override
    public void setSwitch(boolean on) {
        super.setSwitch(on);
        if (on) {
            this.box.setBrightness(1, 1.0f);
        } else {
            this.box.setBrightness(1, 0.4f);
        }
    }

    public void setTexture(int surface, Bitmap bitmap, float brightness) {
        this.box.setTexture(surface, bitmap, brightness);
        if (this.screen != null) {
            this.screen.setTexture(surface, bitmap);
        }
    }
}

