/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLQuaternion;
import de.neo.android.opengl.systems.GLCube;
import javax.microedition.khronos.opengles.GL10;

public class GLLaptop
extends GLFigure {
    public static final int SURFACE_DISPLAY = 1;
    public static final int SURFACE_KEYBOARD = 2;
    private GLCube keyboard;
    private GLCube display;
    private GLQuaternion q = new GLQuaternion();

    public GLLaptop(int style, float angle) {
        super(style);
        this.keyboard = new GLCube(style);
        this.initKeyboard();
        this.display = new GLCube(style);
        this.q.rotateByAngleAxis(-angle, 1.0f, 0.0f, 0.0f);
        this.initDisplay();
    }

    private void initDisplay() {
        this.init(this.display);
        for (int i = 0; i < 3; ++i) {
            this.display.squares[0].mColor[i] = 0.0f;
            this.display.squares[5].mColor[i] = 1.0f;
            this.display.squares[1].mColor[i] = 0.0f;
            this.display.squares[2].mColor[i] = 0.0f;
            this.display.squares[3].mColor[i] = 0.0f;
            this.display.squares[4].mColor[i] = 0.0f;
        }
    }

    private void init(GLCube cube) {
        cube.mSize[0] = 1.0f;
        cube.mSize[1] = 0.05f;
        cube.mSize[2] = 0.6f;
        cube.mPosition[2] = cube.mSize[2] / 2.0f;
    }

    private void initKeyboard() {
        this.init(this.keyboard);
        for (int i = 0; i < 3; ++i) {
            this.keyboard.squares[4].mColor[i] = 1.0f;
            this.keyboard.squares[0].mColor[i] = 0.0f;
            this.keyboard.squares[1].mColor[i] = 0.0f;
            this.keyboard.squares[2].mColor[i] = 0.0f;
            this.keyboard.squares[3].mColor[i] = 0.0f;
            this.keyboard.squares[5].mColor[i] = 0.0f;
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        this.keyboard.setOnClickListener(listener);
        this.display.setOnClickListener(listener);
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        this.keyboard.setOnLongClickListener(listener);
        this.display.setOnLongClickListener(listener);
    }

    public void setTexture(int surface, Bitmap b) {
        if ((surface & 1) > 0) {
            this.display.setTexture(32, b);
        }
        if ((surface & 2) > 0) {
            this.keyboard.setTexture(16, b);
        }
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.keyboard.draw(gl);
        this.q.glRotate(gl);
        this.display.draw(gl);
    }
}

