/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLCircle;
import de.neo.android.opengl.figures.GLCylinder;
import de.neo.android.opengl.figures.GLFigure;
import javax.microedition.khronos.opengles.GL10;

public class GLCylinderClosed
extends GLFigure {
    public static final int CYLINDER = 1;
    public static final int FRONT = 2;
    public static final int BACK = 4;
    private GLCylinder cylinder;
    private GLCircle circleBack;
    private GLCircle circleFront;
    private int surfaces;

    public GLCylinderClosed(int parts, int style) {
        this(parts, style, 7);
    }

    public GLCylinderClosed(int parts, int style, int surfaces) {
        this(parts, style, surfaces, 0.5f, 0.5f, false);
    }

    public GLCylinderClosed(int parts, int style, int surfaces, float radiusFront, float radiusBack, boolean invert) {
        super(style);
        this.surfaces = surfaces;
        if ((surfaces & 1) != 0) {
            this.cylinder = new GLCylinder(parts, radiusFront, radiusBack, style, invert);
        }
        if ((surfaces & 4) != 0) {
            this.circleBack = new GLCircle(parts, style);
            this.circleBack.mSize[0] = this.circleBack.mSize[1] = radiusBack;
            if (!invert) {
                this.circleBack.mRotation.rotateByAngleAxis(Math.PI, 0.0f, 1.0f, 0.0f);
            }
            this.circleBack.mPosition[2] = -0.5f;
        }
        if ((surfaces & 2) != 0) {
            this.circleFront = new GLCircle(parts, style);
            this.circleFront.mSize[0] = this.circleFront.mSize[1] = radiusFront;
            if (invert) {
                this.circleBack.mRotation.rotateByAngleAxis(Math.PI, 0.0f, 1.0f, 0.0f);
            }
            this.circleFront.mPosition[2] = 0.5f;
        }
    }

    public void setColor(int surface, float red, float green, float blue) {
        if ((surface & 1) != 0) {
            this.cylinder.mColor[0] = red;
            this.cylinder.mColor[1] = green;
            this.cylinder.mColor[2] = blue;
        }
        if ((surface & 4) != 0) {
            this.circleBack.mColor[0] = red;
            this.circleBack.mColor[1] = green;
            this.circleBack.mColor[2] = blue;
        }
        if ((surface & 2) != 0) {
            this.circleFront.mColor[0] = red;
            this.circleFront.mColor[1] = green;
            this.circleFront.mColor[2] = blue;
        }
    }

    @Override
    public void setTexture(Bitmap b) {
        this.setTexture(7, b);
    }

    public void setTexture(int surface, Bitmap texture) {
        if ((surface & 1) != 0) {
            this.cylinder.setTexture(texture);
        }
        if ((surface & 4) != 0) {
            this.circleBack.setTexture(texture);
        }
        if ((surface & 2) != 0) {
            this.circleFront.setTexture(texture);
        }
    }

    @Override
    protected void onDraw(GL10 gl) {
        if ((this.surfaces & 1) != 0) {
            this.cylinder.draw(gl);
        }
        if ((this.surfaces & 4) != 0) {
            this.circleBack.draw(gl);
        }
        if ((this.surfaces & 2) != 0) {
            this.circleFront.draw(gl);
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        if (this.cylinder != null) {
            this.cylinder.setOnClickListener(listener);
        }
        if (this.circleBack != null) {
            this.circleBack.setOnClickListener(listener);
        }
        if (this.circleFront != null) {
            this.circleFront.setOnClickListener(listener);
        }
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        if (this.cylinder != null) {
            this.cylinder.setOnLongClickListener(listener);
        }
        if (this.circleBack != null) {
            this.circleBack.setOnLongClickListener(listener);
        }
        if (this.circleFront != null) {
            this.circleFront.setOnLongClickListener(listener);
        }
    }

    public void setColor(float red, float green, float blue) {
        this.setColor(7, red, green, blue);
    }
}

