/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLSquare;
import javax.microedition.khronos.opengles.GL10;

public class GLCube
extends GLFigure {
    public static final int FRONT = 1;
    public static final int BACK = 2;
    public static final int RIGHT = 4;
    public static final int LEFT = 8;
    public static final int TOP = 16;
    public static final int DOWN = 32;
    protected GLSquare[] squares = new GLSquare[6];
    private int style;

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        for (int i = 0; i < this.squares.length; ++i) {
            this.squares[i].style = style;
        }
    }

    public GLCube(int style, int surface) {
        super(style);
        if ((surface & 2) != 0) {
            this.squares[0] = new GLSquare(style);
            this.squares[0].style = style;
            this.squares[0].mPosition[2] = -0.5f;
        }
        if ((surface & 1) != 0) {
            this.squares[1] = new GLSquare(style);
            this.squares[1].style = style;
            this.squares[1].mPosition[2] = 0.5f;
            this.squares[1].mRotation.rotateByAngleAxis(Math.PI, 1.0f, 0.0f, 0.0f);
        }
        if ((surface & 4) != 0) {
            this.squares[2] = new GLSquare(style);
            this.squares[2].style = style;
            this.squares[2].mPosition[0] = 0.5f;
            this.squares[2].mRotation.rotateByAngleAxis(-1.5707963267948966, 0.0f, 1.0f, 0.0f);
        }
        if ((surface & 8) != 0) {
            this.squares[3] = new GLSquare(style);
            this.squares[3].style = style;
            this.squares[3].mPosition[0] = -0.5f;
            this.squares[3].mRotation.rotateByAngleAxis(1.5707963267948966, 0.0f, 1.0f, 0.0f);
        }
        if ((surface & 0x10) != 0) {
            this.squares[4] = new GLSquare(style);
            this.squares[4].style = style;
            this.squares[4].mPosition[1] = 0.5f;
            this.squares[4].mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
        }
        if ((surface & 0x20) != 0) {
            this.squares[5] = new GLSquare(style);
            this.squares[5].style = style;
            this.squares[5].mPosition[1] = -0.5f;
            this.squares[5].mRotation.rotateByAngleAxis(-1.5707963267948966, 1.0f, 0.0f, 0.0f);
        }
    }

    public GLCube(int style) {
        this(style, 63);
    }

    @Override
    public void setTexture(Bitmap b) {
        this.setTexture(63, b);
    }

    public void setTexture(int surface, Bitmap b) {
        if ((surface & 2) != 0) {
            this.squares[0].setTexture(b);
        }
        if ((surface & 1) != 0) {
            this.squares[1].setTexture(b);
        }
        if ((surface & 4) != 0) {
            this.squares[2].setTexture(b);
        }
        if ((surface & 8) != 0) {
            this.squares[3].setTexture(b);
        }
        if ((surface & 0x10) != 0) {
            this.squares[4].setTexture(b);
        }
        if ((surface & 0x20) != 0) {
            this.squares[5].setTexture(b);
        }
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glEnable(2884);
        gl.glCullFace(1028);
        for (int i = 0; i < this.squares.length; ++i) {
            if (this.squares[i] == null) continue;
            this.squares[i].draw(gl);
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        for (int i = 0; i < this.squares.length; ++i) {
            if (this.squares[i] == null) continue;
            this.squares[i].setOnClickListener(listener);
        }
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        for (int i = 0; i < this.squares.length; ++i) {
            if (this.squares[i] == null) continue;
            this.squares[i].setOnLongClickListener(listener);
        }
    }

    public void setColor(float red, float green, float blue) {
        for (int i = 0; i < this.squares.length; ++i) {
            if (this.squares[i] == null) continue;
            this.squares[i].mColor[0] = red;
            this.squares[i].mColor[1] = green;
            this.squares[i].mColor[2] = blue;
        }
    }
}

