/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLBoxplate;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.systems.GLCube;
import de.neo.android.opengl.systems.GLCylinderClosed;
import javax.microedition.khronos.opengles.GL10;

public class GLBox
extends GLFigure {
    public static final int BOX = 1;
    public static final int SPEAKER = 2;
    public static final int Parts = 20;
    private GLCube cube;
    private GLCylinderClosed speaker;
    private GLBoxplate plate;
    private float volume;

    public GLBox(int style) {
        super(style);
        this.cube = new GLCube(style, 62);
        this.cube.mSize[2] = 0.5f;
        this.cube.mSize[0] = 0.5f;
        this.cube.mPosition[1] = 0.5f;
        this.plate = new GLBoxplate(20, 0.25f, 0.2f, 0.75f, 0.125f);
        this.plate.mPosition[2] = 0.25f;
        this.cube.mColor[0] = 0.37f;
        this.plate.mColor[0] = 0.37f;
        this.cube.mColor[1] = 0.28f;
        this.plate.mColor[1] = 0.28f;
        this.cube.mColor[2] = 0.03f;
        this.plate.mColor[2] = 0.03f;
        this.speaker = new GLCylinderClosed(20, style, 5, 0.5f, 0.2f, true);
        this.speaker.setColor(4, 0.5f, 0.5f, 0.5f);
        this.speaker.setColor(1, 0.1f, 0.1f, 0.1f);
        this.speaker.mSize[2] = 0.05f;
        this.speaker.mPosition[2] = this.cube.mSize[2] / 2.0f - this.speaker.mSize[2] / 2.0f;
        this.setVolume(50.0f);
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glEnable(2884);
        gl.glCullFace(1028);
        this.cube.draw(gl);
        if (this.mStyle == 2) {
            this.plate.draw(gl);
        }
        gl.glDisable(2884);
        this.speaker.mPosition[1] = 0.25f;
        this.speaker.mSize[2] = 0.05f + (this.volume / 100.0f - 0.5f) * 0.1f;
        this.speaker.mPosition[2] = this.cube.mSize[2] / 2.0f - this.speaker.mSize[2] / 2.0f;
        this.speaker.mSize[1] = 0.4f;
        this.speaker.mSize[0] = 0.4f;
        this.speaker.draw(gl);
        this.speaker.mSize[1] = 0.25f;
        this.speaker.mSize[0] = 0.25f;
        this.speaker.mPosition[1] = 0.75f;
        this.speaker.draw(gl);
    }

    public void setTexture(int surface, Bitmap b, float brightness) {
        if ((surface & 1) != 0) {
            this.cube.setTexture(62, b);
            this.cube.setColor(brightness, brightness, brightness);
            this.plate.setTexture(b);
            this.plate.mColor[1] = this.plate.mColor[2] = brightness;
            this.plate.mColor[0] = this.plate.mColor[2];
        }
        if ((surface & 2) != 0) {
            this.speaker.setTexture(1, b);
            this.speaker.setColor(1, brightness, brightness, brightness);
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        this.cube.setOnClickListener(listener);
        this.speaker.setOnClickListener(listener);
        this.plate.setOnClickListener(listener);
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        this.cube.setOnLongClickListener(listener);
        this.speaker.setOnLongClickListener(listener);
        this.plate.setOnLongClickListener(listener);
    }

    public void setVolume(float volume) {
        if (volume < 0.0f || volume > 100.0f) {
            throw new IllegalArgumentException("Volume v must be in 0 <= v <= 100. Bad value: " + volume);
        }
        this.volume = volume;
    }

    public void setBrightness(int surface, float brightness) {
        if ((surface & 1) != 0) {
            this.plate.mColor[1] = this.plate.mColor[2] = brightness;
            this.plate.mColor[0] = this.plate.mColor[2];
            this.cube.setColor(brightness, brightness, brightness);
        }
        if ((surface & 2) != 0) {
            this.speaker.mColor[1] = this.speaker.mColor[2] = brightness;
            this.speaker.mColor[0] = this.speaker.mColor[2];
            this.speaker.setColor(5, brightness, brightness, brightness);
        }
    }
}

