/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

public class GLSTL
extends GLFigure {
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mNormalBuffer;
    private ShortBuffer mIndexBuffer;
    private int mIndexCount;

    public GLSTL(InputStream stlStream) throws IOException {
        this(stlStream, null);
    }

    public GLSTL(InputStream stlStream, STLProgress progress) throws IOException {
        super(1);
        stlStream.skip(80L);
        byte[] buffer = new byte[4];
        stlStream.read(buffer);
        int triangleCount = this.getIntWithLittleEndian(buffer);
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        try {
            while (stlStream.skip(12L) == 12L) {
                Triangle triangle = new Triangle();
                triangle.readByStream(stlStream);
                triangle.calulcateNormal();
                triangles.add(triangle);
                if (progress != null && triangles.size() % 50 == 0) {
                    progress.stlLoadingProgress(triangles.size(), triangleCount);
                }
                stlStream.skip(2L);
            }
        }
        catch (IOException triangle) {
            // empty catch block
        }
        float[] vertices = new float[triangles.size() * 3 * 3];
        float[] normals = new float[triangles.size() * 3 * 3];
        short[] indices = new short[triangles.size() * 3 * 3];
        for (int i = 0; i < triangles.size(); ++i) {
            Triangle triangle = (Triangle)triangles.get(i);
            for (int j = 0; j < 3; ++j) {
                vertices[i * 3 * 3 + j * 3 + 0] = triangle.mNodes[j][0];
                vertices[i * 3 * 3 + j * 3 + 1] = triangle.mNodes[j][1];
                vertices[i * 3 * 3 + j * 3 + 2] = triangle.mNodes[j][2];
                normals[i * 3 * 3 + j * 3 + 0] = triangle.mNormal[0];
                normals[i * 3 * 3 + j * 3 + 1] = triangle.mNormal[1];
                normals[i * 3 * 3 + j * 3 + 2] = triangle.mNormal[2];
                indices[i * 3 * 3 + j * 3 + 0] = (short)(i * 3 * 3 + j * 3 + 0);
                indices[i * 3 * 3 + j * 3 + 1] = (short)(i * 3 * 3 + j * 3 + 1);
                indices[i * 3 * 3 + j * 3 + 2] = (short)(i * 3 * 3 + j * 3 + 2);
            }
        }
        this.mVertexBuffer = this.allocate(vertices);
        this.mNormalBuffer = this.allocate(normals);
        this.mIndexBuffer = this.allocate(indices);
        this.mIndexCount = triangleCount * 3;
        this.mStyle = 4;
    }

    private int getIntWithLittleEndian(byte[] bytes) {
        return 0xFF & bytes[0] | (0xFF & bytes[1]) << 8 | (0xFF & bytes[2]) << 16 | (0xFF & bytes[3]) << 24;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glEnable(2884);
        gl.glCullFace(1029);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.mVertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.mNormalBuffer);
        gl.glDrawElements(this.mStyle, this.mIndexCount, 5123, (Buffer)this.mIndexBuffer);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisable(2884);
    }

    static interface STLProgress {
        public void stlLoadingProgress(int var1, int var2);
    }

    class Triangle {
        float[][] mNodes = new float[3][3];
        float[] mNormal = new float[3];

        Triangle() {
        }

        float[] substract(float[] v1, float[] v2) {
            float[] result = new float[]{v1[0] - v2[0], v1[1] - v2[1], v1[2] - v2[2]};
            return result;
        }

        float[] add(float[] v1, float[] v2) {
            float[] result = new float[]{v1[0] + v2[0], v1[1] + v2[1], v1[2] + v2[2]};
            return result;
        }

        float[] crossProduct(float[] v1, float[] v2) {
            float[] result = new float[]{v1[1] * v2[2] - v1[2] * v2[1], v1[2] * v2[0] - v1[0] * v2[2], v1[0] * v2[1] - v1[1] * v2[0]};
            return result;
        }

        float dotProduct(float[] v1, float[] v2) {
            return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        }

        void calulcateNormal() {
            float[] v1 = this.substract(this.mNodes[1], this.mNodes[0]);
            float[] v2 = this.substract(this.mNodes[2], this.mNodes[0]);
            this.mNormal = this.crossProduct(v1, v2);
            float length = this.length(this.mNormal);
            this.mNormal[0] = this.mNormal[0] / length;
            this.mNormal[1] = this.mNormal[1] / length;
            this.mNormal[2] = this.mNormal[2] / length;
        }

        float length(float[] v) {
            return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        }

        public void readByStream(InputStream stlStream) throws IOException {
            byte[] buffer = new byte[4];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    stlStream.read(buffer);
                    this.mNodes[i][j] = Float.intBitsToFloat(GLSTL.this.getIntWithLittleEndian(buffer));
                }
            }
        }
    }
}

