/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLFunctionFigure
extends GLFigure {
    public static final float GEOMETRIC_EPSILON = 0.001f;
    private FloatBuffer vertexBuffer;
    private ShortBuffer indexBuffer;
    private FloatBuffer normalBuffer;
    private short[] indices;
    private int style;
    private FloatBuffer textureBuffer;

    public GLFunctionFigure(int parts, int style, Function f) {
        super(style);
        float[] texture = new float[parts * (parts + 1) * 2];
        this.vertexBuffer = this.allocateFloat(parts * (parts + 1) * 3 * 4);
        this.normalBuffer = this.allocateFloat(parts * (parts + 1) * 3 * 4);
        float stepX = (float)(Math.PI * 2 / (double)parts);
        for (int i = 0; i < parts; ++i) {
            float y = (float)i / (float)(parts - 1);
            float mulX = f.getValue((float)i / (float)(parts - 1));
            float delta = (f.getValue((float)i / (float)(parts - 1) + 0.001f) - mulX) / 0.001f;
            float alpha = (float)Math.atan(delta);
            float sinM = (float)Math.sin(alpha);
            float cosM = (float)Math.cos(alpha);
            for (int j = 0; j <= parts; ++j) {
                float sin = (float)Math.sin(stepX * (float)j);
                float cos = (float)Math.cos(stepX * (float)j);
                this.vertexBuffer.put(cos * mulX);
                this.vertexBuffer.put(y);
                this.vertexBuffer.put(sin * mulX);
                this.normalBuffer.put(cos * cosM);
                this.normalBuffer.put(-sinM);
                this.normalBuffer.put(sin * cosM);
                texture[2 * (i * (parts + 1) + j)] = 1.0f - (float)j / (float)parts;
                texture[2 * (i * (parts + 1) + j) + 1] = 1.0f - (float)i / (float)(parts - 1);
            }
        }
        this.vertexBuffer.position(0);
        this.textureBuffer = this.allocate(texture);
        this.normalBuffer.position(0);
        if (style == 1) {
            this.createGridIndices(parts);
        } else {
            this.createPlaneIndices(parts);
        }
    }

    private void createPlaneIndices(int slices) {
        this.indices = new short[(slices - 1) * (slices + 1) * 2];
        int counter = 0;
        for (int i = 0; i < slices - 1; ++i) {
            for (int j = 0; j <= slices; ++j) {
                this.indices[counter++] = (short)(i * (slices + 1) + j);
                this.indices[counter++] = (short)((i + 1) * (slices + 1) + j);
            }
        }
        this.indexBuffer = this.allocate(this.indices);
        this.style = 5;
    }

    private void createGridIndices(int slices) {
        int i;
        this.indices = new short[slices * slices * 2];
        int counter = 0;
        for (i = 0; i < slices * (slices + 1); ++i) {
            this.indices[counter++] = (short)i;
        }
        for (i = 1; i < slices; ++i) {
            for (int j = 0; j < slices; ++j) {
                this.indices[counter++] = i % 2 == 0 ? (short)((slices + 1) * j + i) : (short)((slices + 1) * (slices - j - 1) + i);
            }
        }
        this.indexBuffer = this.allocate(this.indices);
        this.style = 3;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glEnable(2884);
        gl.glCullFace(1029);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        if (this.mTexture != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.textureBuffer);
        }
        gl.glDrawElements(this.style, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32885);
        gl.glDisableClientState(32884);
    }

    public static interface Function {
        public float getValue(float var1);
    }
}

