/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLCylinder
extends GLFigure {
    private FloatBuffer vertexBuffer;
    private ShortBuffer indexBuffer;
    private FloatBuffer mTextureBuffer;
    private short[] indices;
    private float[] vertex;
    private float[] textureCoordinates;
    private int drawStyle;
    private FloatBuffer normalBuffer;

    public GLCylinder(int parts) {
        this(parts, 1);
    }

    public GLCylinder(int parts, int style) {
        this(parts, 1.0f, 1.0f, style, false);
    }

    public GLCylinder(int parts, float radiusFront, float radiusBack, int style, boolean invert) {
        super(style);
        this.vertex = new float[parts * 6 + 12];
        float[] normal = new float[parts * 6 + 12];
        float steps = (float)(Math.PI * 2 / (double)parts);
        float gegK = radiusFront - radiusBack;
        float hyp = (float)Math.sqrt(gegK * gegK + 1.0f);
        float sinM = gegK / hyp;
        float alpha = (float)Math.asin(sinM);
        float cosM = (float)Math.cos(alpha);
        if (invert) {
            cosM = -cosM;
            sinM = -sinM;
        }
        for (int i = 0; i <= parts; ++i) {
            float sin = (float)Math.sin((double)((float)i * steps) + Math.PI);
            float cos = (float)Math.cos((double)((float)i * steps) + Math.PI);
            this.vertex[i * 3] = sin * radiusBack;
            this.vertex[i * 3 + 1] = cos * radiusBack;
            this.vertex[i * 3 + 2] = -0.5f;
            normal[i * 3] = sin * cosM;
            normal[i * 3 + 1] = cos * cosM;
            normal[i * 3 + 2] = -sinM;
            this.vertex[i * 3 + parts * 3 + 3] = sin * radiusFront;
            this.vertex[i * 3 + parts * 3 + 4] = cos * radiusFront;
            this.vertex[i * 3 + parts * 3 + 5] = 0.5f;
            normal[i * 3 + parts * 3 + 3] = normal[i * 3];
            normal[i * 3 + parts * 3 + 4] = normal[i * 3 + 1];
            normal[i * 3 + parts * 3 + 5] = normal[i * 3 + 2];
        }
        this.vertex[parts * 6 + 6] = 0.0f;
        this.vertex[parts * 6 + 7] = 0.0f;
        this.vertex[parts * 6 + 8] = -0.5f;
        this.vertex[parts * 6 + 9] = 0.0f;
        this.vertex[parts * 6 + 10] = 0.0f;
        this.vertex[parts * 6 + 11] = 0.5f;
        normal[parts * 6 + 6] = 0.0f;
        normal[parts * 6 + 7] = 0.0f;
        normal[parts * 6 + 8] = -1.0f;
        normal[parts * 6 + 9] = 0.0f;
        normal[parts * 6 + 10] = 0.0f;
        normal[parts * 6 + 11] = 1.0f;
        if (style == 1) {
            this.createGridIndices(parts);
        } else {
            this.createPlaneIndices(parts);
        }
        this.vertexBuffer = this.allocate(this.vertex);
        this.normalBuffer = this.allocate(normal);
        this.indexBuffer = this.allocate(this.indices);
    }

    private void createPlaneIndices(int parts) {
        int i;
        this.indices = new short[parts * 6 + 6];
        for (i = 0; i < parts; ++i) {
            this.indices[i * 6] = (short)i;
            this.indices[i * 6 + 1] = (short)(parts + i + 1);
            this.indices[i * 6 + 2] = (short)(i + 1);
            this.indices[i * 6 + 3] = (short)(i + 1);
            this.indices[i * 6 + 4] = (short)(parts + i + 1);
            this.indices[i * 6 + 5] = (short)(parts + i + 2);
        }
        this.textureCoordinates = new float[parts * 4 + 4];
        for (i = 0; i <= parts; ++i) {
            this.textureCoordinates[i * 2] = ((float)parts - (float)i) / (float)parts;
            this.textureCoordinates[i * 2 + 1] = 0.0f;
            this.textureCoordinates[i * 2 + parts * 2 + 2] = ((float)parts - (float)i) / (float)parts;
            this.textureCoordinates[i * 2 + parts * 2 + 3] = 1.0f;
        }
        this.mTextureBuffer = this.allocate(this.textureCoordinates);
        this.drawStyle = 4;
    }

    private void createGridIndices(int parts) {
        this.indices = new short[parts * 4 + 3];
        for (int i = 0; i <= parts; ++i) {
            int offset = i % 2;
            this.indices[i * 2 + offset] = (short)i;
            this.indices[i * 2 + 1 - offset] = (short)(i + parts + 1);
            this.indices[parts * 2 + i * 2 + 2 - offset] = (short)i;
            this.indices[parts * 2 + i * 2 + 1 + offset] = (short)(i + parts + 1);
        }
        this.drawStyle = 3;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        gl.glDisableClientState(32886);
        if (this.mTexture != null && this.mTextureBuffer != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        gl.glDrawElements(this.drawStyle, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisable(2884);
    }
}

