/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLCircle
extends GLFigure {
    private ShortBuffer indexBuffer;
    private FloatBuffer mTextureBuffer;
    private short[] indices;
    private float[] textureCoordinates;
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private int drawStyle;

    public GLCircle(int parts) {
        this(parts, 1);
    }

    public GLCircle(int parts, int style) {
        super(style);
        this.vertexBuffer = this.allocateFloat((parts * 3 + 6) * 4);
        this.normalBuffer = this.allocateFloat((parts * 3 + 6) * 4);
        float steps = (float)(Math.PI * 2 / (double)parts);
        for (int i = 0; i <= parts; ++i) {
            float sin = (float)Math.sin((float)i * steps);
            float cos = (float)Math.cos((float)i * steps);
            this.vertexBuffer.put(sin);
            this.vertexBuffer.put(cos);
            this.vertexBuffer.put(0.0f);
            this.normalBuffer.put(0.0f);
            this.normalBuffer.put(0.0f);
            this.normalBuffer.put(1.0f);
        }
        this.vertexBuffer.put(0.0f);
        this.vertexBuffer.put(0.0f);
        this.vertexBuffer.put(0.0f);
        this.normalBuffer.put(0.0f);
        this.normalBuffer.put(0.0f);
        this.normalBuffer.put(1.0f);
        if (style == 1) {
            this.createGridIndices(parts);
        } else {
            this.createPlaneIndices(parts);
        }
        this.vertexBuffer.position(0);
        this.normalBuffer.position(0);
        this.indexBuffer = this.allocate(this.indices);
    }

    private void createPlaneIndices(int parts) {
        this.indices = new short[parts + 3];
        this.indices[0] = (short)parts;
        for (int i = 0; i <= parts; ++i) {
            this.indices[i + 1] = (short)(i % parts);
        }
        this.textureCoordinates = new float[parts * 2 + 4];
        float steps = (float)(Math.PI * 2 / (double)parts);
        for (int i = 0; i <= parts; ++i) {
            this.textureCoordinates[i * 2 + 0] = (float)(0.5 + Math.sin(steps * (float)i) / 2.0);
            this.textureCoordinates[i * 2 + 1] = (float)(0.5 + Math.cos(steps * (float)i) / 2.0);
        }
        this.textureCoordinates[parts * 2 + 0] = 0.5f;
        this.textureCoordinates[parts * 2 + 1] = 0.5f;
        this.mTextureBuffer = this.allocate(this.textureCoordinates);
        this.drawStyle = 6;
    }

    private void createGridIndices(int parts) {
        this.indices = new short[parts + 1];
        for (int i = 0; i <= parts; ++i) {
            this.indices[i] = (short)(i % parts);
        }
        this.drawStyle = 3;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        gl.glDisableClientState(32886);
        if (this.mTexture != null && this.mTextureBuffer != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        gl.glDrawElements(this.drawStyle, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisable(2884);
    }
}

