/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLBall
extends GLFigure {
    private FloatBuffer mVertexBuffer;
    private ShortBuffer mIndexBuffer;
    private int mIndexCount;
    private int mStyle;
    private FloatBuffer mTextureBuffer;

    public GLBall(int style, int slices) {
        super(style);
        float[] vertices = new float[slices * (slices + 1) * 3];
        float[] texture = new float[slices * (slices + 1) * 2];
        float stepY = (float)(Math.PI / (double)(slices - 1));
        float stepX = (float)(Math.PI * 2 / (double)slices);
        for (int i = 0; i < slices; ++i) {
            float y = (float)Math.cos(stepY * (float)i) / 2.0f;
            float mulX = (float)Math.sin(stepY * (float)i) / 2.0f;
            for (int j = 0; j <= slices; ++j) {
                float x = (float)Math.cos(stepX * (float)j) * mulX;
                float z = (float)Math.sin(stepX * (float)j) * mulX;
                vertices[3 * (i * (slices + 1) + j)] = x;
                vertices[3 * (i * (slices + 1) + j) + 1] = y;
                vertices[3 * (i * (slices + 1) + j) + 2] = z;
                texture[2 * (i * (slices + 1) + j)] = 1.0f - (float)j / (float)slices;
                texture[2 * (i * (slices + 1) + j) + 1] = 1.0f - (float)i / (float)(slices - 1);
            }
        }
        this.mVertexBuffer = this.allocate(vertices);
        this.mTextureBuffer = this.allocate(texture);
        this.mIndexCount = texture.length;
        if (style == 1) {
            this.createGridIndices(slices);
        } else {
            this.createPlaneIndices(slices);
        }
    }

    private void createPlaneIndices(int slices) {
        short[] indices = new short[(slices - 1) * (slices + 1) * 2];
        int counter = 0;
        for (int i = 0; i < slices - 1; ++i) {
            for (int j = 0; j <= slices; ++j) {
                indices[counter++] = (short)(i * (slices + 1) + j);
                indices[counter++] = (short)((i + 1) * (slices + 1) + j);
            }
        }
        this.mIndexBuffer = this.allocate(indices);
        this.mStyle = 5;
    }

    private void createGridIndices(int slices) {
        int i;
        short[] indices = new short[slices * slices * 2];
        int counter = 0;
        for (i = 0; i < slices * (slices + 1); ++i) {
            indices[counter++] = (short)i;
        }
        for (i = 1; i < slices; ++i) {
            for (int j = 0; j < slices; ++j) {
                indices[counter++] = i % 2 == 0 ? (short)((slices + 1) * j + i) : (short)((slices + 1) * (slices - j - 1) + i);
            }
        }
        this.mIndexBuffer = this.allocate(indices);
        this.mStyle = 3;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glEnable(2884);
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.mVertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.mVertexBuffer);
        if (this.mTexture != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        gl.glDrawElements(this.mStyle, this.mIndexCount, 5123, (Buffer)this.mIndexBuffer);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
    }
}

