/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter.blanknode;

import de.atextor.turtle.formatter.blanknode.BlankNodeMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileWrapper;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.sparql.util.Context;

public class BlankNodeOrderAwareTurtleParser {
    public static ParseResult parseModel(String content) {
        final BlankNodeMetadata bnodeMetadata = new BlankNodeMetadata();
        Lang TTL_bn = LangBuilder.create((String)"TTL_BN", (String)"text/bogus").build();
        RDFParserRegistry.registerLangTriples((Lang)TTL_bn, (ReaderRIOTFactory)new ReaderRIOTFactory(){

            public ReaderRIOT create(Lang language, ParserProfile profile) {
                ParserProfileWrapper profileWrapper = new ParserProfileWrapper(profile){

                    public Node createBlankNode(Node scope, String label, long line, long col) {
                        Node blank = this.get().createBlankNode(scope, label, line, col);
                        bnodeMetadata.registerNewBlankNode(blank, label);
                        return blank;
                    }

                    public Node createBlankNode(Node scope, long line, long col) {
                        Node blank = this.get().createBlankNode(scope, line, col);
                        bnodeMetadata.registerNewBlankNode(blank);
                        return blank;
                    }

                    public Node create(Node currentGraph, Token token) {
                        long line = token.getLine();
                        long col = token.getColumn();
                        String str = token.getImage();
                        if (token.getType() == TokenType.BNODE) {
                            return this.createBlankNode(currentGraph, str, line, col);
                        }
                        return this.get().create(currentGraph, token);
                    }
                };
                return new ReaderRIOT(){
                    final /* synthetic */ ParserProfile val$profileWrapper;
                    {
                        this.val$profileWrapper = parserProfile;
                    }

                    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
                        LangRIOT parser = RiotParsers.createParser((InputStream)in, (Lang)Lang.TTL, (StreamRDF)output, (ParserProfile)this.val$profileWrapper);
                        parser.parse();
                    }

                    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
                        LangRIOT parser = RiotParsers.createParser((Reader)reader, (Lang)Lang.TTL, (StreamRDF)output, (ParserProfile)this.val$profileWrapper);
                        parser.parse();
                    }
                };
            }
        });
        Graph graph = RDFParser.source((InputStream)new ByteArrayInputStream(content.getBytes())).labelToNode(LabelToNode.createUseLabelAsGiven()).lang(TTL_bn).toGraph();
        RDFParserRegistry.removeRegistration((Lang)TTL_bn);
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        bnodeMetadata.linkGraphNodesToModelResources(model);
        return new ParseResult(model, bnodeMetadata);
    }

    public static class ParseResult {
        private final Model model;
        private final BlankNodeMetadata blankNodeMetadata;

        public ParseResult(Model model, BlankNodeMetadata blankNodeMetadata) {
            this.model = model;
            this.blankNodeMetadata = blankNodeMetadata;
        }

        public Model getModel() {
            return this.model;
        }

        public BlankNodeMetadata getBlankNodeMetadata() {
            return this.blankNodeMetadata;
        }
    }
}

