/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter.blanknode;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class BlankNodeMetadata {
    private final Map<Node, Long> blankNodeIndex = new HashMap<Node, Long>();
    private final Map<Node, String> blankNodeLabels = new HashMap<Node, String>();
    private final Set<Resource> labeledBlankNodes = new HashSet<Resource>();
    private long nextIndex = 0L;

    public void linkGraphNodesToModelResources(Model model) {
        this.labeledBlankNodes.addAll(model.listStatements().toList().stream().flatMap(s -> Stream.of(s.getSubject(), s.getObject())).filter(RDFNode::isAnon).filter(a -> this.blankNodeLabels.containsKey(a.asNode())).map(RDFNode::asResource).collect(Collectors.toSet()));
    }

    public static BlankNodeMetadata gotNothing() {
        return new BlankNodeMetadata();
    }

    public Long getOrder(Node node) {
        return this.blankNodeIndex.get(node);
    }

    public String getLabel(Node node) {
        return this.blankNodeLabels.get(node);
    }

    void registerNewBlankNode(Node blankNode) {
        if (blankNode.isBlank() && !this.blankNodeIndex.containsKey(blankNode)) {
            this.blankNodeIndex.put(blankNode, this.nextIndex++);
        }
    }

    void registerNewBlankNode(Node blankNode, String label) {
        this.registerNewBlankNode(blankNode);
        this.blankNodeLabels.put(blankNode, label);
    }

    public Set<Resource> getLabeledBlankNodes() {
        return Collections.unmodifiableSet(this.labeledBlankNodes);
    }

    public Set<String> getAllBlankNodeLabels() {
        return Collections.unmodifiableSet(new HashSet<String>(this.blankNodeLabels.values()));
    }
}

