/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter;

import de.atextor.turtle.formatter.blanknode.BlankNodeMetadata;
import java.util.Comparator;
import java.util.Optional;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;

public class RDFNodeComparatorFactory {
    private final PrefixMapping prefixMapping;
    private final BlankNodeMetadata blankNodeOrdering;
    private final RDFNodeComparator rdfNodeComparator = new RDFNodeComparator();

    public RDFNodeComparatorFactory(PrefixMapping prefixMapping, BlankNodeMetadata blankNodeOrdering) {
        this.prefixMapping = prefixMapping;
        this.blankNodeOrdering = blankNodeOrdering;
    }

    public RDFNodeComparatorFactory(PrefixMapping prefixMapping) {
        this(prefixMapping, null);
    }

    public RDFNodeComparator comparator() {
        return this.rdfNodeComparator;
    }

    private class RDFNodeComparator
    implements Comparator<RDFNode> {
        private RDFNodeComparator() {
        }

        @Override
        public int compare(RDFNode left, RDFNode right) {
            if (left.isURIResource()) {
                if (right.isURIResource()) {
                    return RDFNodeComparatorFactory.this.prefixMapping.shortForm(left.asResource().getURI()).compareTo(RDFNodeComparatorFactory.this.prefixMapping.shortForm(right.asResource().getURI()));
                }
                if (right.isAnon()) {
                    return -1;
                }
            } else if (left.isAnon()) {
                if (right.isAnon()) {
                    if (RDFNodeComparatorFactory.this.blankNodeOrdering != null) {
                        return Optional.ofNullable(RDFNodeComparatorFactory.this.blankNodeOrdering.getOrder(left.asResource().asNode())).orElse(Long.MAX_VALUE).compareTo(Optional.ofNullable(RDFNodeComparatorFactory.this.blankNodeOrdering.getOrder(right.asResource().asNode())).orElse(Long.MAX_VALUE));
                    }
                } else if (right.isResource()) {
                    return 1;
                }
            }
            return left.toString().compareTo(right.toString());
        }
    }
}

