/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchemaContext {
    String schemaUri;
    String schemaType;
    private final Map<String, Object> schemaMap;
    String schemaName;
    String schemaDescription;
    String schemaContent;
    List<Property> properties;

    public SchemaContext(String string, String string2) {
        this.schemaName = string;
        this.schemaContent = string2;
        this.schemaMap = this.schemaAsMap(string2);
        this.schemaDescription = (String)this.schemaMap.get("description");
        this.schemaUri = (String)this.schemaMap.get("$schema");
        this.schemaType = (String)this.schemaMap.get("type");
        this.properties = this.readProperties(this.schemaMap);
    }

    private List<Property> readProperties(Map<String, Object> map) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        Map map2 = (Map)map.get("properties");
        for (Map.Entry entry : map2.entrySet()) {
            PropertyDefinition propertyDefinition = this.readPropertyDefinitionFromMap((Map)entry.getValue());
            arrayList.add(new Property((String)entry.getKey(), propertyDefinition));
        }
        return arrayList;
    }

    private PropertyDefinition readPropertyDefinitionFromMap(Map<String, Object> map) {
        String string = (String)map.get("type");
        String string2 = (String)map.get("description");
        String string3 = (String)map.get("$ref");
        String string4 = (String)map.get("targetType");
        return new PropertyDefinition(string2, string).withReference(string3).withTargetType(string4);
    }

    Map schemaAsMap(String string) {
        try {
            return (Map)new ObjectMapper().readValue(string, Map.class);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSchemaContent() {
        return ((String)Optional.of((Object)this.schemaContent).or((Object)"")).trim();
    }

    public Map getSchemaMap() {
        return this.schemaMap;
    }

    public String getSchemaDescription() {
        return this.schemaDescription;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String toString() {
        return "SchemaContext{schemaName='" + this.schemaName + '\'' + ", schemaContent='" + this.schemaContent + '\'' + '}';
    }

    static class PropertyDefinition {
        String description;
        String type;
        List<String> requiredFields;
        int minimum;
        int maximum;
        String reference;
        String targetType;

        public PropertyDefinition(String string, String string2) {
            this.description = string;
            this.type = string2;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getReference() {
            return this.reference;
        }

        public PropertyDefinition withReference(String string) {
            this.reference = string;
            return this;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public PropertyDefinition withTargetType(String string) {
            this.targetType = string;
            return this;
        }
    }

    static class Property {
        String name;
        PropertyDefinition definition;

        public Property(String string, PropertyDefinition propertyDefinition) {
            this.name = string;
            this.definition = propertyDefinition;
        }

        public String getName() {
            return this.name;
        }

        public PropertyDefinition getDefinition() {
            return this.definition;
        }
    }
}

